/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DependencyBuilder;

@Mojo(name="display-parent-updates", threadSafe=true)
public class DisplayParentUpdatesMojo
extends AbstractVersionsDisplayMojo {
    public static final int MESSAGE_LENGTH = 68;

    @Inject
    public DisplayParentUpdatesMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        ArtifactVersion artifactVersion;
        this.logInit();
        if (this.getProject().getParent() == null) {
            this.logLine(false, "Project does not have a parent.");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.logLine(false, "Parent project is part of the reactor.");
            return;
        }
        String currentVersion = this.getProject().getParent().getVersion();
        Artifact artifact = this.getHelper().createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(currentVersion).withType("pom").build());
        try {
            artifactVersion = this.findLatestVersion(artifact, null, this.allowSnapshots, false);
        }
        catch (VersionRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (artifactVersion == null || currentVersion.equals(artifactVersion.toString())) {
            this.logLine(false, "The parent project is the latest version:");
            StringBuilder buf = new StringBuilder(68);
            buf.append("  ");
            buf.append(this.getProject().getParent().getGroupId());
            buf.append(':');
            buf.append(this.getProject().getParent().getArtifactId());
            buf.append(' ');
            int padding = 68 - currentVersion.length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(currentVersion);
            this.logLine(false, buf.toString());
        } else {
            this.logLine(false, "The parent project has a newer version:");
            StringBuilder buf = new StringBuilder(68);
            buf.append("  ");
            buf.append(this.getProject().getParent().getGroupId());
            buf.append(':');
            buf.append(this.getProject().getParent().getArtifactId());
            buf.append(' ');
            int padding = 68 - currentVersion.length() - artifactVersion.toString().length() - " -> ".length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(currentVersion);
            buf.append(" -> ");
            buf.append(artifactVersion);
            this.logLine(false, buf.toString());
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) {
    }
}

