/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codehaus.mojo.versions.PluginUpdatesDetails;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.PropertyVersionsBuilder;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.IgnoreVersion;
import org.codehaus.mojo.versions.model.Rule;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.model.io.xpp3.RuleXpp3Reader;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparators;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.PluginComparator;
import org.codehaus.mojo.versions.utils.RegexUtils;
import org.codehaus.mojo.versions.utils.VersionsExpressionEvaluator;
import org.codehaus.mojo.versions.utils.WagonUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultVersionsHelper
implements VersionsHelper {
    private static final String CLASSPATH_PROTOCOL = "classpath";
    private static final String TYPE_EXACT = "exact";
    private static final String TYPE_REGEX = "regex";
    private static final int LOOKUP_PARALLEL_THREADS = 5;
    private RuleSet ruleSet;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactRepository localRepository;
    private List<ArtifactRepository> remoteArtifactRepositories;
    private List<ArtifactRepository> remotePluginRepositories;
    private RepositorySystem repositorySystem;
    private Log log;
    private MavenSession mavenSession;
    private ArtifactResolver artifactResolver;
    private MojoExecution mojoExecution;
    private final Map<String, Rule> artifactBestFitRule = new HashMap<String, Rule>();

    private DefaultVersionsHelper() {
    }

    /*
     * Loose catch block
     */
    @Deprecated
    private static RuleSet getRuleSet(Wagon wagon, String remoteURI) throws IOException, AuthorizationException, TransferFailedException, ResourceDoesNotExistException {
        File tempFile = File.createTempFile("ruleset", ".xml");
        try {
            wagon.get(remoteURI, tempFile);
            try (InputStream is = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);){
                RuleSet ruleSet = DefaultVersionsHelper.readRulesFromStream(is);
                return ruleSet;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!tempFile.delete()) {
                tempFile.deleteOnExit();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static RuleSet readRulesFromStream(InputStream stream) throws IOException {
        RuleXpp3Reader reader = new RuleXpp3Reader();
        try (BufferedInputStream bis = new BufferedInputStream(stream);){
            RuleSet ruleSet = reader.read(bis);
            return ruleSet;
        }
        catch (XmlPullParserException e) {
            throw new IOException(e);
        }
    }

    static boolean exactMatch(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, true));
        return p.matcher(value).matches();
    }

    static boolean match(String wildcardRule, String value) {
        Pattern p = Pattern.compile(RegexUtils.convertWildcardsToRegex(wildcardRule, false));
        return p.matcher(value).matches();
    }

    private static RuleSet enrichRuleSet(Collection<String> ignoredVersions, RuleSet originalRuleSet) {
        RuleSet ruleSet = new RuleSet();
        if (originalRuleSet != null) {
            ruleSet.setComparisonMethod(originalRuleSet.getComparisonMethod());
            if (originalRuleSet.getRules() != null) {
                ruleSet.setRules(new ArrayList<Rule>(originalRuleSet.getRules()));
            }
            if (originalRuleSet.getIgnoreVersions() != null) {
                ruleSet.setIgnoreVersions(new ArrayList<IgnoreVersion>(originalRuleSet.getIgnoreVersions()));
            }
        }
        if (ruleSet.getIgnoreVersions() == null) {
            ruleSet.setIgnoreVersions(new ArrayList<IgnoreVersion>());
        }
        ruleSet.getIgnoreVersions().addAll(ignoredVersions.stream().map(v -> {
            IgnoreVersion ignoreVersion = new IgnoreVersion();
            ignoreVersion.setType(TYPE_REGEX);
            ignoreVersion.setVersion((String)v);
            return ignoreVersion;
        }).collect(Collectors.toList()));
        return ruleSet;
    }

    private static RuleSet getRulesFromClasspath(String uri, Log logger) throws MojoExecutionException {
        logger.debug((CharSequence)("Going to load rules from \"" + uri + "\""));
        String choppedUrl = uri.substring(CLASSPATH_PROTOCOL.length() + 3);
        URL url = DefaultVersionsHelper.class.getResource(choppedUrl);
        if (null == url) {
            String message = "Resource \"" + uri + "\" not found in classpath.";
            throw new MojoExecutionException(message);
        }
        try {
            RuleSet rules = DefaultVersionsHelper.readRulesFromStream(url.openStream());
            logger.debug((CharSequence)("Loaded rules from \"" + uri + "\" successfully"));
            return rules;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load specified rules from " + uri, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuleSet getRulesViaWagon(String rulesUri, Log logger, String serverId, String id, WagonManager wagonManager, Settings settings) throws MojoExecutionException {
        RuleSet loadedRules;
        int split = rulesUri.lastIndexOf(47);
        String baseUri = rulesUri;
        String fileUri = "";
        if (split != -1) {
            baseUri = rulesUri.substring(0, split) + '/';
            fileUri = split + 1 < rulesUri.length() ? rulesUri.substring(split + 1) : "";
        }
        try {
            Wagon wagon = WagonUtils.createWagon(serverId, baseUri, wagonManager, settings, logger);
            try {
                logger.debug((CharSequence)("Trying to load ruleset from file \"" + fileUri + "\" in " + baseUri));
                loadedRules = DefaultVersionsHelper.getRuleSet(wagon, fileUri);
            }
            finally {
                logger.debug((CharSequence)"Rule set loaded");
                if (wagon != null) {
                    try {
                        wagon.disconnect();
                    }
                    catch (ConnectionException e) {
                        logger.warn((CharSequence)"Could not disconnect wagon!", (Throwable)e);
                    }
                }
            }
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Could not transfer rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Authorization failure trying to load rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (IOException | ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Could not load specified rules from " + rulesUri, (Exception)e);
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Authentication failure trying to load rules from " + rulesUri, (Exception)((Object)e));
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Unsupported protocol for " + rulesUri, (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Could not establish connection to " + rulesUri, (Exception)((Object)e));
        }
        return loadedRules;
    }

    static boolean isClasspathUri(String uri) {
        return uri != null && uri.startsWith("classpath:");
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public ArtifactVersions lookupArtifactVersions(Artifact artifact, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        List<ArtifactRepository> remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, remoteRepositories);
        List<IgnoreVersion> ignoredVersions = this.getIgnoredVersions(artifact);
        if (!ignoredVersions.isEmpty()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Found ignored versions: " + this.showIgnoredVersions(ignoredVersions)));
            }
            Iterator i = versions.iterator();
            block0: while (i.hasNext()) {
                String version = ((ArtifactVersion)i.next()).toString();
                for (IgnoreVersion ignoreVersion : ignoredVersions) {
                    if (TYPE_REGEX.equals(ignoreVersion.getType())) {
                        Pattern p = Pattern.compile(ignoreVersion.getVersion());
                        if (!p.matcher(version).matches()) continue;
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Version " + version + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + ignoreVersion));
                        }
                        i.remove();
                        continue block0;
                    }
                    if (!TYPE_EXACT.equals(ignoreVersion.getType()) || !version.equals(ignoreVersion.getVersion())) continue;
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Version " + version + " for artifact " + ArtifactUtils.versionlessKey((Artifact)artifact) + " found on ignore list: " + ignoreVersion));
                    }
                    i.remove();
                    continue block0;
                }
            }
        }
        return new ArtifactVersions(artifact, versions, this.getVersionComparator(artifact));
    }

    private List<IgnoreVersion> getIgnoredVersions(Artifact artifact) {
        ArrayList<IgnoreVersion> ret = new ArrayList<IgnoreVersion>();
        for (IgnoreVersion ignoreVersion : this.ruleSet.getIgnoreVersions()) {
            if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for global ignoreVersion[" + ignoreVersion + "] is not valid. Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                continue;
            }
            ret.add(ignoreVersion);
        }
        Rule rule = this.getBestFitRule(artifact.getGroupId(), artifact.getArtifactId());
        if (rule != null) {
            for (IgnoreVersion ignoreVersion : rule.getIgnoreVersions()) {
                if (!TYPE_EXACT.equals(ignoreVersion.getType()) && !TYPE_REGEX.equals(ignoreVersion.getType())) {
                    this.getLog().warn((CharSequence)("The type attribute '" + ignoreVersion.getType() + "' for " + rule + " is not valid. Please use either '" + TYPE_EXACT + "' or '" + TYPE_REGEX + "'."));
                    continue;
                }
                ret.add(ignoreVersion);
            }
        }
        return ret;
    }

    private String showIgnoredVersions(List<IgnoreVersion> ignoredVersions) {
        StringBuilder buf = new StringBuilder();
        Iterator<IgnoreVersion> iterator = ignoredVersions.iterator();
        while (iterator.hasNext()) {
            IgnoreVersion ignoreVersion = iterator.next();
            buf.append(ignoreVersion);
            if (!iterator.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    @Override
    public void resolveArtifact(Artifact artifact, boolean usePluginRepositories) throws ArtifactResolutionException, ArtifactNotFoundException {
        List<ArtifactRepository> remoteRepositories = usePluginRepositories ? this.remotePluginRepositories : this.remoteArtifactRepositories;
        this.artifactResolver.resolve(artifact, remoteRepositories, this.localRepository);
    }

    @Override
    public VersionComparator getVersionComparator(Artifact artifact) {
        return this.getVersionComparator(artifact.getGroupId(), artifact.getArtifactId());
    }

    @Override
    public VersionComparator getVersionComparator(String groupId, String artifactId) {
        Rule rule = this.getBestFitRule(groupId, artifactId);
        String comparisonMethod = rule == null ? this.ruleSet.getComparisonMethod() : rule.getComparisonMethod();
        return VersionComparators.getVersionComparator(comparisonMethod);
    }

    protected Rule getBestFitRule(String groupId, String artifactId) {
        String groupArtifactId = groupId + ':' + artifactId;
        if (this.artifactBestFitRule.containsKey(groupArtifactId)) {
            return this.artifactBestFitRule.get(groupArtifactId);
        }
        Rule bestFit = null;
        List<Rule> rules = this.ruleSet.getRules();
        int bestGroupIdScore = Integer.MAX_VALUE;
        int bestArtifactIdScore = Integer.MAX_VALUE;
        boolean exactGroupId = false;
        boolean exactArtifactId = false;
        for (Rule rule : rules) {
            int artifactIdScore;
            boolean exactMatch;
            boolean match;
            int groupIdScore = RegexUtils.getWildcardScore(rule.getGroupId());
            if (groupIdScore > bestGroupIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getGroupId(), groupId)) || DefaultVersionsHelper.match(rule.getGroupId(), groupId)) || exactGroupId && !exactMatch) continue;
            if (bestGroupIdScore > groupIdScore) {
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            bestGroupIdScore = groupIdScore;
            if (exactMatch && !exactGroupId) {
                exactGroupId = true;
                bestArtifactIdScore = Integer.MAX_VALUE;
                exactArtifactId = false;
            }
            if ((artifactIdScore = RegexUtils.getWildcardScore(rule.getArtifactId())) > bestArtifactIdScore || !(match = (exactMatch = DefaultVersionsHelper.exactMatch(rule.getArtifactId(), artifactId)) || DefaultVersionsHelper.match(rule.getArtifactId(), artifactId)) || exactArtifactId && !exactMatch) continue;
            bestArtifactIdScore = artifactIdScore;
            if (exactMatch && !exactArtifactId) {
                exactArtifactId = true;
            }
            bestFit = rule;
        }
        this.artifactBestFitRule.put(groupArtifactId, bestFit);
        return bestFit;
    }

    @Override
    public Artifact createPluginArtifact(String groupId, String artifactId, String version) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(groupId);
        plugin.setArtifactId(artifactId);
        plugin.setVersion(StringUtils.isNotBlank((String)version) ? version : "[0,]");
        return this.repositorySystem.createPluginArtifact(plugin);
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope, boolean optional) {
        return this.repositorySystem.createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(groupId).withArtifactId(artifactId).withType(type).withClassifier(classifier).withScope(scope).withOptional(optional).withVersion(StringUtils.isNotBlank((String)version) ? version : "[0,]").build());
    }

    @Override
    public Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope) {
        return this.createDependencyArtifact(groupId, artifactId, version, type, classifier, scope, false);
    }

    @Override
    public Artifact createDependencyArtifact(Dependency dependency) {
        if (StringUtils.isBlank((String)dependency.getVersion())) {
            dependency = dependency.clone();
            dependency.setVersion("[,0]");
        }
        return this.repositorySystem.createDependencyArtifact(dependency);
    }

    @Override
    public Set<Artifact> extractArtifacts(Collection<MavenProject> mavenProjects) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (MavenProject project : mavenProjects) {
            result.add(project.getArtifact());
        }
        return result;
    }

    @Override
    public ArtifactVersion createArtifactVersion(String version) {
        return new DefaultArtifactVersion(version);
    }

    @Override
    public Map<Dependency, ArtifactVersions> lookupDependenciesUpdates(Set<Dependency> dependencies, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            TreeMap<Dependency, Object> dependencyUpdates = new TreeMap<Dependency, Object>(DependencyComparator.INSTANCE);
            List futures = dependencies.stream().map(dependency -> executor.submit(() -> new ImmutablePair(dependency, (Object)this.lookupDependencyUpdates((Dependency)dependency, usePluginRepositories)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                dependencyUpdates.put((Dependency)pair.getKey(), pair.getValue());
            }
            TreeMap<Dependency, Object> treeMap = dependencyUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new ArtifactMetadataRetrievalException("Unable to acquire metadata for dependencies " + dependencies + ": " + ie.getMessage(), (Throwable)ie, null);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public ArtifactVersions lookupDependencyUpdates(Dependency dependency, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException {
        ArtifactVersions allVersions = this.lookupArtifactVersions(this.createDependencyArtifact(dependency), usePluginRepositories);
        return new ArtifactVersions(allVersions.getArtifact(), Arrays.stream(allVersions.getAllUpdates()).collect(Collectors.toList()), allVersions.getVersionComparator());
    }

    @Override
    public Map<Plugin, PluginUpdatesDetails> lookupPluginsUpdates(Set<Plugin> plugins, boolean allowSnapshots) throws ArtifactMetadataRetrievalException {
        ExecutorService executor = Executors.newFixedThreadPool(5);
        try {
            TreeMap<Object, Object> pluginUpdates = new TreeMap<Object, Object>(PluginComparator.INSTANCE);
            List futures = plugins.stream().map(p -> executor.submit(() -> new ImmutablePair(p, (Object)this.lookupPluginUpdates((Plugin)p, allowSnapshots)))).collect(Collectors.toList());
            for (Future details : futures) {
                Pair pair = (Pair)details.get();
                pluginUpdates.put(pair.getKey(), pair.getValue());
            }
            TreeMap<Object, Object> treeMap = pluginUpdates;
            return treeMap;
        }
        catch (InterruptedException | ExecutionException ie) {
            throw new ArtifactMetadataRetrievalException("Unable to acquire metadata for plugins " + plugins + ": " + ie.getMessage(), (Throwable)ie, null);
        }
        finally {
            executor.shutdown();
        }
    }

    @Override
    public PluginUpdatesDetails lookupPluginUpdates(Plugin plugin, boolean allowSnapshots) throws ArtifactMetadataRetrievalException {
        String version = plugin.getVersion() != null ? plugin.getVersion() : "LATEST";
        TreeSet<Dependency> pluginDependencies = new TreeSet<Dependency>(DependencyComparator.INSTANCE);
        if (plugin.getDependencies() != null) {
            pluginDependencies.addAll(plugin.getDependencies());
        }
        Map<Dependency, ArtifactVersions> pluginDependencyDetails = this.lookupDependenciesUpdates(pluginDependencies, false);
        ArtifactVersions allVersions = this.lookupArtifactVersions(this.createPluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), version), true);
        ArtifactVersions updatedVersions = new ArtifactVersions(allVersions.getArtifact(), Arrays.stream(allVersions.getAllUpdates()).collect(Collectors.toList()), allVersions.getVersionComparator());
        return new PluginUpdatesDetails(updatedVersions, pluginDependencyDetails, allowSnapshots);
    }

    @Override
    public ExpressionEvaluator getExpressionEvaluator(MavenProject project) {
        return new VersionsExpressionEvaluator(this.mavenSession, this.mojoExecution);
    }

    @Override
    public Map<Property, PropertyVersions> getVersionPropertiesMap(MavenProject project, Property[] propertyDefinitions, String includeProperties, String excludeProperties, boolean autoLinkItems) throws MojoExecutionException {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        if (propertyDefinitions != null) {
            for (Property propertyDefinition : propertyDefinitions) {
                properties.put(propertyDefinition.getName(), propertyDefinition);
            }
        }
        HashMap<String, PropertyVersionsBuilder> builders = new HashMap<String, PropertyVersionsBuilder>();
        if (autoLinkItems) {
            PropertyVersionsBuilder[] propertyVersionsBuilders;
            try {
                propertyVersionsBuilders = PomHelper.getPropertyVersionsBuilders(this, project);
            }
            catch (IOException | ExpressionEvaluationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            for (PropertyVersionsBuilder propertyVersionsBuilder : propertyVersionsBuilders) {
                String name = propertyVersionsBuilder.getName();
                builders.put(name, propertyVersionsBuilder);
                if (properties.containsKey(name)) continue;
                Property value = new Property(name);
                this.getLog().debug((CharSequence)("Property ${" + name + "}: Adding inferred version range of " + propertyVersionsBuilder.getVersionRange()));
                value.setVersion(propertyVersionsBuilder.getVersionRange());
                properties.put(name, value);
            }
        }
        List<String> includePropertiesList = this.getSplitProperties(includeProperties);
        List<String> excludePropertiesList = this.getSplitProperties(excludeProperties);
        this.getLog().debug((CharSequence)"Searching for properties associated with builders");
        Iterator i = properties.values().iterator();
        while (i.hasNext()) {
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("includePropertiesList:" + includePropertiesList + " property: " + property.getName()));
            this.getLog().debug((CharSequence)("excludePropertiesList:" + excludePropertiesList + " property: " + property.getName()));
            if (!includePropertiesList.isEmpty() && !includePropertiesList.contains(property.getName())) {
                this.getLog().debug((CharSequence)("Skipping property ${" + property.getName() + "}"));
                i.remove();
                continue;
            }
            if (excludePropertiesList.isEmpty() || !excludePropertiesList.contains(property.getName())) continue;
            this.getLog().debug((CharSequence)("Ignoring property ${" + property.getName() + "}"));
            i.remove();
        }
        i = properties.values().iterator();
        LinkedHashMap<Property, PropertyVersions> propertyVersions = new LinkedHashMap<Property, PropertyVersions>(properties.size());
        while (i.hasNext()) {
            Dependency[] dependencies;
            Property property = (Property)i.next();
            this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}"));
            PropertyVersionsBuilder builder = (PropertyVersionsBuilder)builders.get(property.getName());
            if (builder == null || !builder.isAssociated()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Looks like this property is not associated with any dependency..."));
                builder = new PropertyVersionsBuilder(null, property.getName(), this);
            }
            if (!property.isAutoLinkDependencies()) {
                this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Removing any autoLinkDependencies"));
                builder.clearAssociations();
            }
            if ((dependencies = property.getDependencies()) != null) {
                for (Dependency dependency : dependencies) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding association to " + dependency));
                    builder.addAssociation(this.createDependencyArtifact(dependency), false);
                }
            }
            try {
                PropertyVersions versions = builder.newPropertyVersions();
                if (property.isAutoLinkDependencies() && StringUtils.isEmpty((String)property.getVersion()) && !StringUtils.isEmpty((String)builder.getVersionRange())) {
                    this.getLog().debug((CharSequence)("Property ${" + property.getName() + "}: Adding inferred version range of " + builder.getVersionRange()));
                    property.setVersion(builder.getVersionRange());
                }
                versions.setCurrentVersion(project.getProperties().getProperty(property.getName()));
                propertyVersions.put(property, versions);
            }
            catch (ArtifactMetadataRetrievalException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return propertyVersions;
    }

    private List<String> getSplitProperties(String commaSeparatedProperties) {
        List<String> propertiesList = Collections.emptyList();
        if (StringUtils.isNotEmpty((String)commaSeparatedProperties)) {
            String[] splittedProps = StringUtils.split((String)commaSeparatedProperties, (String)",");
            propertiesList = Arrays.asList(StringUtils.stripAll((String[])splittedProps));
        }
        return propertiesList;
    }

    public static class Builder {
        private RepositorySystem repositorySystem;
        private ArtifactResolver artifactResolver;
        private ArtifactMetadataSource artifactMetadataSource;
        private List<ArtifactRepository> remoteArtifactRepositories;
        private List<ArtifactRepository> remotePluginRepositories;
        private ArtifactRepository localRepository;
        private Collection<String> ignoredVersions;
        private RuleSet ruleSet;
        private WagonManager wagonManager;
        private Settings settings;
        private String serverId;
        private String rulesUri;
        private Log log;
        private MavenSession mavenSession;
        private MojoExecution mojoExecution;

        public Builder withRepositorySystem(RepositorySystem repositorySystem) {
            this.repositorySystem = repositorySystem;
            return this;
        }

        public Builder withArtifactResolver(ArtifactResolver artifactResolver) {
            this.artifactResolver = artifactResolver;
            return this;
        }

        public Builder withArtifactMetadataSource(ArtifactMetadataSource artifactMetadataSource) {
            this.artifactMetadataSource = artifactMetadataSource;
            return this;
        }

        public Builder withRemoteArtifactRepositories(List<ArtifactRepository> remoteArtifactRepositories) {
            this.remoteArtifactRepositories = remoteArtifactRepositories;
            return this;
        }

        public Builder withRemotePluginRepositories(List<ArtifactRepository> remotePluginRepositories) {
            this.remotePluginRepositories = remotePluginRepositories;
            return this;
        }

        public Builder withLocalRepository(ArtifactRepository localRepository) {
            this.localRepository = localRepository;
            return this;
        }

        public Builder withIgnoredVersions(Collection<String> ignoredVersions) {
            this.ignoredVersions = ignoredVersions;
            return this;
        }

        public Builder withRuleSet(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
            return this;
        }

        public Builder withWagonManager(WagonManager wagonManager) {
            this.wagonManager = wagonManager;
            return this;
        }

        public Builder withSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder withServerId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder withRulesUri(String rulesUri) {
            this.rulesUri = rulesUri;
            return this;
        }

        public Builder withLog(Log log) {
            this.log = log;
            return this;
        }

        public Builder withMavenSession(MavenSession mavenSession) {
            this.mavenSession = mavenSession;
            return this;
        }

        public Builder withMojoExecution(MojoExecution mojoExecution) {
            this.mojoExecution = mojoExecution;
            return this;
        }

        public DefaultVersionsHelper build() throws MojoExecutionException {
            DefaultVersionsHelper instance = new DefaultVersionsHelper();
            instance.repositorySystem = this.repositorySystem;
            instance.artifactResolver = this.artifactResolver;
            instance.mavenSession = this.mavenSession;
            instance.mojoExecution = this.mojoExecution;
            if (this.ruleSet != null) {
                if (!Builder.isBlank(this.rulesUri)) {
                    this.log.warn((CharSequence)"rulesUri is ignored if rules are specified in pom or as parameters");
                }
                instance.ruleSet = this.ruleSet;
            } else {
                instance.ruleSet = Builder.isBlank(this.rulesUri) ? new RuleSet() : (DefaultVersionsHelper.isClasspathUri(this.rulesUri) ? DefaultVersionsHelper.getRulesFromClasspath(this.rulesUri, this.log) : DefaultVersionsHelper.getRulesViaWagon(this.rulesUri, this.log, this.serverId, this.serverId, this.wagonManager, this.settings));
            }
            if (this.ignoredVersions != null && !this.ignoredVersions.isEmpty()) {
                instance.ruleSet = DefaultVersionsHelper.enrichRuleSet(this.ignoredVersions, instance.ruleSet);
            }
            instance.artifactMetadataSource = this.artifactMetadataSource;
            instance.localRepository = this.localRepository;
            instance.remoteArtifactRepositories = this.remoteArtifactRepositories;
            instance.remotePluginRepositories = this.remotePluginRepositories;
            instance.log = this.log;
            return instance;
        }

        private static boolean isBlank(String s) {
            return s == null || s.trim().isEmpty();
        }
    }
}

