/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy;

import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tidy.task.PomTidy;
import org.codehaus.plexus.util.FileUtils;

public abstract class TidyMojo
extends AbstractMojo {
    private static final PomTidy POM_TIDY = new PomTidy();
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;

    protected abstract void executeForPom(String var1) throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String pom = this.getProjectPom();
        this.executeForPom(pom);
    }

    private String getProjectPom() throws MojoExecutionException {
        try {
            return FileUtils.fileRead((File)this.getPomFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read the POM.", (Exception)e);
        }
    }

    protected File getPomFile() {
        return this.project.getFile();
    }

    protected String tidy(String pom) throws MojoExecutionException {
        try {
            return POM_TIDY.tidy(pom);
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

