/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.solaris;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.solaris.AbstractSolarisMojo;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;

public class ResourcesMojo
extends AbstractSolarisMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private Resource solarisResources;
    private List resources;
    private File pkginfo;
    private File packageRoot;
    private Properties properties;
    private String artifactId;
    private String version;
    private String name;
    private String description;
    private File basedir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.mkdirs(this.packageRoot);
        this.copyResources();
        this.copySolarisResources();
        this.copyPkginfo();
    }

    private void copyResources() throws MojoExecutionException {
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            this.copyResource(resource);
        }
    }

    private void copySolarisResources() throws MojoExecutionException {
        if (this.solarisResources == null) {
            this.solarisResources = new Resource();
            this.solarisResources.setDirectory(new File(this.basedir, "src/main/resources-solaris").getAbsolutePath());
        }
        this.copyResource(this.solarisResources);
    }

    private void copyPkginfo() throws MojoFailureException, MojoExecutionException {
        Properties properties = new Properties();
        properties.put("project.artifactId", this.artifactId);
        properties.put("project.version", this.version);
        properties.put("project.name", StringUtils.clean((String)this.name));
        properties.put("project.description", StringUtils.clean((String)this.description));
        if (this.properties != null) {
            properties.putAll((Map<?, ?>)this.properties);
        }
        if (!this.pkginfo.canRead()) {
            throw new MojoFailureException("Can't read template pkginfo file: '" + this.pkginfo.getAbsolutePath() + "'.");
        }
        File processedPkginfo = new File(this.packageRoot, "pkginfo");
        FileWriter pkginfoWriter = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(this.pkginfo);
            InterpolationFilterReader reader = new InterpolationFilterReader((Reader)fileReader, (Map)properties);
            pkginfoWriter = new FileWriter(processedPkginfo);
            IOUtil.copy((Reader)reader, (Writer)pkginfoWriter);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while interpolating pkginfo.", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(pkginfoWriter);
                IOUtil.close((Reader)fileReader);
                throw throwable;
            }
        }
        IOUtil.close((Writer)pkginfoWriter);
        IOUtil.close((Reader)fileReader);
    }

    private void copyResource(Resource resource) throws MojoExecutionException {
        File directory = this.getFile(resource.getDirectory());
        if (directory == null || !directory.isDirectory()) {
            this.getLog().debug((CharSequence)("Not a directory: " + directory));
            return;
        }
        try {
            resource.setTargetPath(this.packageRoot.getAbsolutePath());
            this.copy(resource);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not copy files from '" + directory.getAbsolutePath() + "' to '" + this.packageRoot.getAbsolutePath() + "'.", (Exception)e);
        }
    }

    private void copy(Resource resource) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        Object[] includes = DEFAULT_INCLUDES;
        List includesList = resource.getIncludes();
        if (includesList != null && !includesList.isEmpty()) {
            scanner.setIncludes(includesList.toArray(new String[includesList.size()]));
        }
        scanner.setIncludes((String[])includes);
        Object[] excludes = null;
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            excludes = resource.getExcludes().toArray(new String[resource.getExcludes().size()]);
        }
        scanner.setExcludes(excludes);
        this.getLog().debug((CharSequence)"Copying resources...");
        this.getLog().debug((CharSequence)("  From:     " + resource.getDirectory()));
        this.getLog().debug((CharSequence)("  To:       " + resource.getTargetPath()));
        this.getLog().debug((CharSequence)("  Includes: " + StringUtils.join((Object[])includes, (String)",")));
        if (excludes != null) {
            this.getLog().debug((CharSequence)("  Excludes: " + StringUtils.join((Object[])excludes, (String)",")));
        } else {
            this.getLog().debug((CharSequence)"  Excludes: none");
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
        Iterator<String> j = includedFiles.iterator();
        while (j.hasNext()) {
            String name = j.next();
            File source = new File(resource.getDirectory(), name);
            File destinationFile = new File(resource.getTargetPath(), name);
            if (!destinationFile.getParentFile().exists()) {
                destinationFile.getParentFile().mkdirs();
            }
            if (destinationFile.lastModified() >= source.lastModified()) continue;
            FileUtils.copyFile((File)source, (File)destinationFile);
        }
    }

    private File getFile(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.basedir, path);
    }
}

