/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.solaris;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.solaris.AbstractSolarisMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PackagePkgMojo
extends AbstractSolarisMojo {
    private File basedir;
    private File packageRoot;
    private File solarisDir;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File prototypeFile = new File(this.packageRoot, "prototype");
        File pkginfoFile = new File(this.packageRoot, "pkginfo");
        if (!prototypeFile.canRead()) {
            throw new MojoFailureException("Could not read prototype file '" + prototypeFile.getAbsolutePath() + "'.");
        }
        if (!pkginfoFile.canRead()) {
            throw new MojoFailureException("Could not read pkginfo file '" + pkginfoFile.getAbsolutePath() + "'.");
        }
        String packageName = this.getPkgName(pkginfoFile);
        this.pkgmk(prototypeFile);
        File pkgFile = this.pkgtrans(packageName);
        this.project.getArtifact().setFile(pkgFile);
    }

    private String getPkgName(File pkginfoFile) throws MojoExecutionException, MojoFailureException {
        String string;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(pkginfoFile);
            Properties properties = new Properties();
            properties.load(inputStream);
            String packageName = properties.getProperty("PKG");
            if (packageName == null) {
                throw new MojoFailureException("Could not read package name (PKG) from pkginfo file: '" + pkginfoFile.getAbsolutePath() + "'.");
            }
            string = packageName;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while reading pkginfo file.");
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)inputStream);
        return string;
    }

    private void pkgmk(File prototypeFile) throws MojoFailureException, MojoExecutionException {
        Commandline commandline = new Commandline();
        commandline.setExecutable("pkgmk");
        commandline.setWorkingDirectory(this.basedir.getAbsolutePath());
        commandline.createArgument().setValue("-o");
        commandline.createArgument().setValue("-d");
        commandline.createArgument().setValue(this.solarisDir.getAbsolutePath());
        commandline.createArgument().setValue("-f");
        commandline.createArgument().setValue(prototypeFile.getAbsolutePath());
        commandline.createArgument().setValue("-r");
        commandline.createArgument().setValue(this.packageRoot.getAbsolutePath());
        this.execute(commandline, "pkgmk");
    }

    private File pkgtrans(String packageName) throws MojoFailureException, MojoExecutionException {
        File pkgFile = new File(this.solarisDir, packageName + ".pkg");
        Commandline commandline = new Commandline();
        commandline.setExecutable("pkgtrans");
        commandline.setWorkingDirectory(this.basedir.getAbsolutePath());
        commandline.createArgument().setValue("-s");
        commandline.createArgument().setValue("-o");
        commandline.createArgument().setValue(this.solarisDir.getAbsolutePath());
        commandline.createArgument().setValue(pkgFile.getAbsolutePath());
        commandline.createArgument().setValue(packageName);
        this.execute(commandline, "pkgtrans");
        return pkgFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(Commandline commandline, String programName) throws MojoFailureException, MojoExecutionException {
        PkgStreamConsumer streamConsumer = null;
        try {
            File outputFile = new File(this.solarisDir, programName + "-output.txt");
            FileOutputStream fos = new FileOutputStream(outputFile);
            streamConsumer = new PkgStreamConsumer(fos);
            this.getLog().debug((CharSequence)("Executing: " + programName));
            this.getLog().debug((CharSequence)("Working directory: " + commandline.getWorkingDirectory()));
            this.getLog().debug((CharSequence)commandline.toString());
            this.getLog().debug((CharSequence)("The output is in " + outputFile.getAbsolutePath()));
            int exitValue = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)streamConsumer, (StreamConsumer)streamConsumer);
            if (exitValue != 0) {
                throw new MojoFailureException(programName + " " + "returned a non-zero exit code. See the output file for output: " + outputFile.getAbsolutePath());
            }
        }
        catch (CommandLineException e) {
            try {
                throw new MojoExecutionException("Error executing " + programName + " command.", (Exception)((Object)e));
                catch (FileNotFoundException e2) {
                    throw new MojoExecutionException("Error while opening file.", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(streamConsumer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)streamConsumer);
    }

    private class PkgStreamConsumer
    extends PrintWriter
    implements StreamConsumer {
        public PkgStreamConsumer(FileOutputStream fos) {
            super(fos);
        }

        public synchronized void consumeLine(String line) {
            this.println(line);
        }
    }
}

