/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.solaris;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.solaris.AbstractEntryCollection;
import org.codehaus.mojo.solaris.AbstractPrototypeEntry;
import org.codehaus.mojo.solaris.Defaults;
import org.codehaus.mojo.solaris.DirectoryCollection;
import org.codehaus.mojo.solaris.DirectoryEntry;
import org.codehaus.mojo.solaris.EditableCollection;
import org.codehaus.mojo.solaris.EditableEntry;
import org.codehaus.mojo.solaris.FileCollection;
import org.codehaus.mojo.solaris.FileEntry;
import org.codehaus.mojo.solaris.PrototypeGenerator;
import org.codehaus.mojo.solaris.SinglePrototypeEntry;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;

public class DefaultPrototypeGenerator
extends AbstractLogEnabled
implements PrototypeGenerator {
    public Iterator generatePrototype(File packageRoot, List prototype, Defaults directoryDefaults, Defaults fileDefaults) throws MojoFailureException, MojoExecutionException {
        prototype = this.getEntries(prototype);
        Iterator it = prototype.iterator();
        while (it.hasNext()) {
            Object entry = it.next();
            Defaults defaults = entry instanceof DirectoryEntry || entry instanceof DirectoryCollection ? directoryDefaults : fileDefaults;
            AbstractPrototypeEntry prototypeEntry = (AbstractPrototypeEntry)entry;
            prototypeEntry.validate(defaults);
        }
        DirectoryCollection defaultDirectoryCollection = new DirectoryCollection(directoryDefaults.getPkgClass(), directoryDefaults.getMode(), directoryDefaults.getUser(), directoryDefaults.getGroup(), directoryDefaults.getIncludes(), directoryDefaults.getExcludes());
        FileCollection defaultFileCollection = new FileCollection(fileDefaults.getPkgClass(), fileDefaults.getMode(), fileDefaults.getUser(), fileDefaults.getGroup(), fileDefaults.getIncludes(), fileDefaults.getExcludes());
        prototype.add(0, defaultDirectoryCollection);
        prototype.add(0, defaultFileCollection);
        PrototypeEntryList collectedPrototypeEntries = new PrototypeEntryList();
        Iterator it2 = prototype.iterator();
        while (it2.hasNext()) {
            String[] includedFiles;
            int i;
            Object entry = it2.next();
            if (entry instanceof SinglePrototypeEntry) {
                collectedPrototypeEntries.put((SinglePrototypeEntry)entry);
                continue;
            }
            AbstractEntryCollection collection = (AbstractEntryCollection)entry;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(packageRoot);
            scanner.setIncludes(collection.getIncludes());
            scanner.setExcludes(collection.getExcludes());
            scanner.scan();
            if (collection instanceof DirectoryCollection) {
                String[] includedDirectories = scanner.getIncludedDirectories();
                for (i = 0; i < includedDirectories.length; ++i) {
                    String includedDirectory = includedDirectories[i];
                    if (includedDirectory.equals("/")) continue;
                    collectedPrototypeEntries.put(new DirectoryEntry(collection.getPkgClass(), collection.getMode(), collection.getUser(), collection.getGroup(), "/" + includedDirectory, null));
                }
            }
            if (collection instanceof FileCollection) {
                includedFiles = scanner.getIncludedFiles();
                for (i = 0; i < includedFiles.length; ++i) {
                    collectedPrototypeEntries.put(new FileEntry(collection.getPkgClass(), collection.getMode(), collection.getUser(), collection.getGroup(), "/" + includedFiles[i], null));
                }
            }
            if (!(collection instanceof EditableCollection)) continue;
            includedFiles = scanner.getIncludedFiles();
            for (i = 0; i < includedFiles.length; ++i) {
                collectedPrototypeEntries.put(new EditableEntry(collection.getPkgClass(), collection.getMode(), collection.getUser(), collection.getGroup(), "/" + includedFiles[i], null));
            }
        }
        return collectedPrototypeEntries.iterator();
    }

    private List getEntries(List original) {
        return original == null ? new LinkedList() : original;
    }

    private class PrototypeEntryList {
        private TreeSet collectedPrototypeEntries;

        private PrototypeEntryList() {
            this.collectedPrototypeEntries = new TreeSet(new Comparator(){

                public int compare(Object o, Object o1) {
                    SinglePrototypeEntry a = (SinglePrototypeEntry)o;
                    SinglePrototypeEntry b = (SinglePrototypeEntry)o1;
                    return a.getPath().compareTo(b.getPath());
                }
            });
        }

        public void put(SinglePrototypeEntry entry) {
            this.collectedPrototypeEntries.remove(entry);
            this.collectedPrototypeEntries.add(entry);
        }

        public Iterator iterator() {
            return this.collectedPrototypeEntries.iterator();
        }
    }
}

