/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.smc;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DotConvertor {
    public static void convert(List files, String[] formats, Log log) throws CommandLineException {
        for (int i = 0; i < files.size(); ++i) {
            File file = (File)files.get(i);
            for (int j = 0; j < formats.length; ++j) {
                String format = formats[j];
                DotConvertor.convert(file, format, log);
            }
        }
    }

    public static int convert(File file, String format, Log log) throws CommandLineException {
        String errOutput;
        Commandline cl = new Commandline();
        cl.setExecutable("dot");
        cl.createArgument().setValue("-T" + format);
        cl.createArgument().setValue("-o");
        cl.createArgument().setValue(file.getAbsolutePath().replace(".dot", "." + format));
        cl.createArgument().setValue(file.getAbsolutePath());
        log.debug((CharSequence)("executing: " + cl.toString()));
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        String output = stdout.getOutput();
        if (output.length() > 0) {
            log.debug((CharSequence)output);
        }
        if ((errOutput = stderr.getOutput()).length() > 0) {
            log.warn((CharSequence)errOutput);
        }
        return exitCode;
    }
}

