/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;

public final class Selector {
    private String id;
    private String classifier;
    private String type;

    public Selector(String type, String classifier) {
        this.type = type;
        this.classifier = classifier;
    }

    public Selector(String type) {
        this(type, null);
    }

    public Selector() {
    }

    public String getId() {
        if (this.id == null) {
            if (this.classifier == null) {
                return this.type;
            }
            return this.type + ":" + this.classifier;
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selector selector = (Selector)o;
        if (this.classifier != null ? !this.classifier.equals(selector.classifier) : selector.classifier != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(selector.type) : selector.type != null);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "groupId:artifactId:version" + (this.type == null ? "" : ":" + this.type) + (this.classifier == null ? "" : ":" + this.classifier) + (this.id == null ? "" : " [" + this.id + "]");
    }

    public boolean matches(Artifact artifact) {
        if (!(StringUtils.isEmpty((String)this.type) || this.type.equals(artifact.getType()) || this.type.equals(artifact.getArtifactHandler().getExtension()) || this.type.equals(artifact.getArtifactHandler().getPackaging()))) {
            return false;
        }
        if (this.classifier == null) {
            return artifact.getClassifier() == null;
        }
        return this.classifier.equals(artifact.getClassifier());
    }
}

