/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.scmchangelog.changelog.log.grammar;

import org.codehaus.mojo.scmchangelog.changelog.log.Message;
import org.codehaus.mojo.scmchangelog.changelog.log.ScmGrammar;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.AcceptAllScmGrammar;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.BugzillaScmGrammar;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.ManuScmGrammar;
import org.codehaus.mojo.scmchangelog.changelog.log.grammar.RemyScmGrammar;

public class GrammarEnum {
    public static final GrammarEnum MANU = new GrammarEnum(new ManuScmGrammar(), "MANU");
    public static final GrammarEnum REMY = new GrammarEnum(new RemyScmGrammar(), "REMY");
    public static final GrammarEnum BUGZILLA = new GrammarEnum(new BugzillaScmGrammar(), "BUGZILLA");
    public static final GrammarEnum ALL = new GrammarEnum(new AcceptAllScmGrammar(), "ALL");
    private ScmGrammar grammar;
    private String name;

    private GrammarEnum(ScmGrammar grammar, String name) {
        this.grammar = grammar;
        this.name = name;
    }

    public Message extractMessage(String content) {
        String realContent = this.grammar.removeComments(content);
        return this.grammar.extractMessage(realContent);
    }

    public boolean hasMessage(String content) {
        return this.grammar.hasMessage(content);
    }

    public String getIssueSeparator() {
        return this.grammar.getIssueSeparator();
    }

    public static GrammarEnum valueOf(String name) {
        if (GrammarEnum.REMY.name.equalsIgnoreCase(name)) {
            return REMY;
        }
        if (GrammarEnum.BUGZILLA.name.equalsIgnoreCase(name)) {
            return BUGZILLA;
        }
        if (GrammarEnum.ALL.name.equalsIgnoreCase(name)) {
            return ALL;
        }
        return MANU;
    }
}

