/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tools.rpm;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.tools.platform.PlatformDetectionException;
import org.codehaus.mojo.tools.platform.detective.PlatformDetective;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.VersionRangeFormatter;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class RpmInfoFormatter
implements LogEnabled {
    private PlatformDetective platformDetective;
    private VersionRangeFormatter versionRangeFormatter;
    private String rpmPlatformName;
    private Logger logger;

    public RpmInfoFormatter() {
    }

    public RpmInfoFormatter(PlatformDetective detective, VersionRangeFormatter versionRangeFormatter) {
        this.platformDetective = detective;
        this.versionRangeFormatter = versionRangeFormatter;
    }

    public String formatRpmNameWithoutVersion(MavenProject project) throws RpmFormattingException {
        return this.formatRpmName(project, null, null, false, null, false);
    }

    public String formatRpmDependency(MavenProject project) throws InvalidVersionSpecificationException {
        StringBuffer dependency = new StringBuffer();
        String versionString = project.getVersion();
        List<String> restrictions = this.versionRangeFormatter.getRpmVersionRestrictions(versionString);
        if (restrictions != null && !restrictions.isEmpty()) {
            Iterator<String> it = restrictions.iterator();
            while (it.hasNext()) {
                String restriction = it.next();
                dependency.append(project.getGroupId().replace('.', '_'));
                dependency.append('_');
                dependency.append(project.getArtifactId().replace('.', '_'));
                dependency.append(restriction);
                if (!it.hasNext()) continue;
                dependency.append(' ');
            }
        } else {
            dependency.append(project.getGroupId().replace('.', '_'));
            dependency.append('_');
            dependency.append(project.getArtifactId().replace('.', '_'));
        }
        return dependency.toString();
    }

    public String formatRpmName(MavenProject project, String rpmVersion, String release, boolean withVersionInfo, String platformPostfix, boolean skipPlatformPostfix) throws RpmFormattingException {
        StringBuffer rpmName = new StringBuffer();
        Properties properties = project.getProperties();
        String rpmNamePrefix = properties.getProperty("applicationName");
        this.getLogger().debug("Prefixing RPM name with: '" + rpmNamePrefix + "'");
        if (rpmNamePrefix != null) {
            rpmName.append(rpmNamePrefix);
            rpmName.append("_");
        }
        if (RpmInfoFormatter.getUseRpmFinalName(project)) {
            rpmName.append(project.getBuild().getFinalName());
        } else {
            rpmName.append(project.getGroupId().replace('.', '_'));
            rpmName.append('_');
            rpmName.append(project.getArtifactId().replace('.', '_'));
            if (withVersionInfo) {
                String releaseInfo = this.formatProjectRelease(release, platformPostfix, skipPlatformPostfix);
                rpmName.append('-').append(rpmVersion).append('-').append(releaseInfo);
            }
        }
        this.getLogger().info("RPM Name: '" + rpmName.toString() + "'");
        return rpmName.toString();
    }

    public String formatProjectRelease(String release, String platformPostfix, boolean skipPlatformPostfix) throws RpmFormattingException {
        String rpmRelease = new String(release);
        if (!skipPlatformPostfix && platformPostfix != null && platformPostfix.trim().length() > 0) {
            rpmRelease = rpmRelease + "." + platformPostfix;
        }
        return rpmRelease;
    }

    public String formatRPMPlatformName() throws RpmFormattingException {
        if (this.rpmPlatformName == null) {
            String operatingSystemToken;
            try {
                operatingSystemToken = this.platformDetective.getOperatingSystemToken();
            }
            catch (ComponentLookupException e) {
                throw new RpmFormattingException("Error reading platform distribution information. Component Lookup problem", e);
            }
            catch (PlatformDetectionException e) {
                throw new RpmFormattingException("Error reading platform distribution information.", e);
            }
            this.rpmPlatformName = operatingSystemToken.replace('.', '_');
        }
        return this.rpmPlatformName;
    }

    public String formatPlatformArchitecture() throws RpmFormattingException {
        try {
            return this.platformDetective.getArchitectureToken();
        }
        catch (PlatformDetectionException e) {
            throw new RpmFormattingException("Error reading platform distribution information.", e);
        }
    }

    public static boolean getUseRpmFinalName(MavenProject project) {
        String rpmUseFinalName = project.getProperties().getProperty("rpm.useFinalName");
        boolean useFinalName = false;
        if (rpmUseFinalName != null) {
            useFinalName = Boolean.valueOf(rpmUseFinalName);
        }
        return useFinalName;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected final Logger getLogger() {
        if (this.logger == null) {
            this.logger = new ConsoleLogger(1, "RpmInfoFormatter-lazyLoggerInstance");
        }
        return this.logger;
    }
}

