/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rpm.AbstractRpmInstallMojo;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInstallException;

public class InstallRpmMojo
extends AbstractRpmInstallMojo {
    private boolean skipInstall;
    private boolean forceInstall;
    private String rpmVersion;
    private String release;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipInstall) {
            this.getLog().info((CharSequence)"Skipping RPM build (per configuration).");
            return;
        }
        File rpmFile = null;
        List attachedList = this.project.getAttachedArtifacts();
        for (Artifact artifact : attachedList) {
            this.getLog().debug((CharSequence)("rpm install: Found Artifact " + artifact.getId() + " type " + artifact.getType()));
            if (artifact.getType() != "rpm") continue;
            rpmFile = artifact.getFile();
        }
        if (rpmFile == null) {
            throw new MojoFailureException((Object)this, "RPM file does not exist.", "RPM file has not been set on project artifact for: " + this.project.getId());
        }
        if (!rpmFile.exists()) {
            throw new MojoFailureException((Object)this, "RPM file does not exist.", "Cannot install missing RPM: " + rpmFile);
        }
        try {
            this.install(this.project, this.rpmVersion, this.release, this.forceInstall);
        }
        catch (RpmInstallException e) {
            throw new MojoExecutionException("Failed to install project RPM for: " + this.project, (Exception)e);
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Failed to install project RPM for: " + this.project, (Exception)e);
        }
    }
}

