/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.rpm.ProjectRpmFileManager;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.mojo.tools.rpm.RpmFormattingException;
import org.codehaus.mojo.tools.rpm.RpmInfoFormatter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildRpmMojo
extends AbstractMojo {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String[] DEFAULT_RPMRC_INCLUDES = new String[]{"/usr/lib/rpm/rpmrc", "/usr/lib/rpm/redhat/rpmrc", "/etc/rpmrc", USER_HOME + "/.rpmrc"};
    public static final String MACROFILES_HEADER = "macrofiles";
    private List<String> rpmrcIncludes;
    private boolean skipBuild;
    private String prefix;
    private String platformPostfix;
    private boolean skipPlatformPostfix;
    private String rpmName;
    private String rpmVersion;
    private MavenProject project;
    private File topDir;
    private File destDir;
    private File rpmsDir;
    private String release;
    private CommandLineManager cliManager;
    private RpmInfoFormatter rpmInfoFormatter;
    private ProjectRpmFileManager projectRpmFileManager;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.skipBuild) {
            this.getLog().info((CharSequence)"Skipping RPM build (per configuration).");
            return;
        }
        String rpmBaseName = this.calculateRpmBaseName();
        this.buildRpmDirectoryStructure();
        File rpmrc = this.createRpmConfigurationFiles();
        this.buildRpm(rpmBaseName, rpmrc);
        this.chmodTopDirContents();
        this.setProjectArtifactFile(rpmBaseName);
    }

    private File createRpmConfigurationFiles() throws MojoExecutionException {
        File rpmConfigDir = new File(this.topDir, "maven-rpm-config");
        rpmConfigDir.mkdirs();
        File tmpDir = new File(this.topDir, "tmp");
        tmpDir.mkdirs();
        File rpmrc = new File(rpmConfigDir, "rpmrc");
        File macros = new File(rpmConfigDir, "macros");
        List<String> includes = this.getRpmrcIncludes();
        String macroFiles = this.getMacroFiles();
        FileWriter writer = null;
        try {
            writer = new FileWriter(rpmrc);
            for (String include : includes) {
                writer.write("include : ");
                writer.write(include);
                writer.write(LINE_SEPARATOR);
            }
            writer.write("macrofiles : ");
            writer.write(macroFiles);
            if (macroFiles.length() > 0) {
                writer.write(58);
            }
            writer.write(macros.getCanonicalPath());
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to write rpmrc file in: " + rpmrc, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
        writer = null;
        try {
            writer = new FileWriter(macros);
            writer.write("%_topdir\t\t ");
            writer.write(this.topDir.getCanonicalPath());
            writer.write(LINE_SEPARATOR);
            writer.write("%_tmppath\t\t ");
            writer.write(tmpDir.getCanonicalPath());
            writer.write(LINE_SEPARATOR);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write RPM macros file in: " + macros, (Exception)e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
        return rpmrc;
    }

    private List<String> getRpmrcIncludes() throws MojoExecutionException {
        List<String> includes = this.rpmrcIncludes;
        if (includes == null || includes.isEmpty()) {
            List<String> defaultLocations = Arrays.asList(DEFAULT_RPMRC_INCLUDES);
            this.getLog().debug((CharSequence)("Using default rpmrc locations: " + defaultLocations));
            includes = new ArrayList<String>(defaultLocations);
        }
        if (includes != null && !includes.isEmpty()) {
            Iterator<String> it = includes.iterator();
            while (it.hasNext()) {
                String include = it.next();
                File includeFile = new File(include = StringUtils.replace((String)include, (String)"~", (String)USER_HOME));
                if (includeFile.exists() && includeFile.isFile()) continue;
                this.getLog().debug((CharSequence)("rpmrc file: " + includeFile + " does not exist. It will be excluded."));
                it.remove();
            }
        }
        return includes;
    }

    private String getMacroFiles() throws MojoExecutionException {
        RpmrcParsingConsumer consumer = new RpmrcParsingConsumer(MACROFILES_HEADER);
        Commandline cli = new Commandline();
        BourneShell shell = new BourneShell(true);
        shell.setQuotedArgumentsEnabled(false);
        cli.setShell((Shell)shell);
        cli.setExecutable("rpm");
        cli.createArg().setLine("--showrc");
        try {
            int result = this.cliManager.execute(cli, (StreamConsumer)consumer, this.cliManager.newDebugStreamConsumer());
            if (result != 0) {
                throw new MojoExecutionException("rpm command returned an exit value != 0. Aborting build; see debug output for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error reading rc info from rpm.", (Exception)((Object)e));
        }
        return consumer.getValue();
    }

    private void setProjectArtifactFile(String rpmBaseName) throws MojoExecutionException {
        if (RpmInfoFormatter.getUseRpmFinalName(this.project)) {
            rpmBaseName = rpmBaseName + "-" + this.project.getVersion() + "-" + this.release;
        }
        this.getLog().debug((CharSequence)("Just before setting the final RPM project-artifact, release is: " + this.release + "; rpmBaseName is: " + rpmBaseName));
        this.projectRpmFileManager.formatAndSetProjectArtifactFile(this.project, this.projectHelper, this.topDir, rpmBaseName, this.skipPlatformPostfix);
        List attachedArtifacts = this.project.getAttachedArtifacts();
        if (attachedArtifacts.isEmpty()) {
            throw new MojoExecutionException("RPM file: " + rpmBaseName + " did not get attatched.");
        }
        for (Artifact artifact : attachedArtifacts) {
            if (!artifact.getFile().exists()) {
                throw new MojoExecutionException("RPM artifact: " + artifact.getFile().toString() + " does not exist.");
            }
            this.getLog().info((CharSequence)("extension:  " + artifact.getArtifactHandler().getExtension()));
            this.getLog().info((CharSequence)("classifier: " + artifact.getArtifactHandler().getClassifier()));
            this.getLog().info((CharSequence)("packaging:  " + artifact.getArtifactHandler().getPackaging()));
        }
    }

    private String calculateRpmBaseName() throws MojoExecutionException {
        String rpmBaseName = null;
        if (this.rpmName != null && this.rpmName.trim().length() > 0) {
            rpmBaseName = this.rpmName;
        } else {
            try {
                rpmBaseName = this.rpmInfoFormatter.formatRpmName(this.project, this.rpmVersion, this.release, true, this.platformPostfix, this.skipPlatformPostfix);
            }
            catch (RpmFormattingException e) {
                throw new MojoExecutionException("Failed to format RPM name. Reason: " + e.getMessage(), (Exception)e);
            }
        }
        return rpmBaseName;
    }

    private void buildRpm(String rpmBaseName, File rpmrc) throws MojoExecutionException {
        Commandline cli = new Commandline();
        File tmpPath = new File(this.topDir, "tmp");
        cli.setShell((Shell)new BourneShell(true));
        cli.setExecutable("rpmbuild");
        File specFile = new File(this.topDir + "/SPECS/" + rpmBaseName + ".spec");
        cli.createArg().setLine("-bb --macros=" + this.getMacroFiles() + " --define \"_tmppath " + tmpPath.getAbsolutePath() + "\" --define \"_topdir " + this.topDir.getAbsolutePath() + "\" --define \"buildroot " + this.destDir.getAbsolutePath() + "\" " + specFile.getAbsolutePath());
        StreamConsumer consumer = this.cliManager.newInfoStreamConsumer();
        try {
            int result = this.cliManager.execute(cli, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("rpmbuild command returned an exit value != 0. Aborting build; see command output above for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to build RPM. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void chmodTopDirContents() throws MojoExecutionException {
        Commandline chmod = new Commandline();
        chmod.setExecutable("chmod");
        chmod.createArg().setLine("-R g+w " + this.topDir.getAbsolutePath());
        try {
            StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
            int result = this.cliManager.execute(chmod, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException("chmod command returned an exit value != 0. Aborting build; see debug output for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to chmod g+w RPM topdir: " + this.topDir + ". Reason: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void buildRpmDirectoryStructure() throws MojoExecutionException {
        File temps;
        this.topDir.mkdirs();
        File build = new File(this.topDir, "BUILD");
        build.mkdirs();
        try {
            this.rpmsDir = new File(this.topDir, "RPMS/" + this.rpmInfoFormatter.formatPlatformArchitecture());
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot read OS architecture from rpm command.", (Exception)e);
        }
        this.getLog().info((CharSequence)("RPMS Directory: '" + this.rpmsDir.getAbsolutePath() + "'"));
        this.rpmsDir.mkdirs();
        File sources = new File(this.topDir, "SOURCES");
        sources.mkdirs();
        File specs = new File(this.topDir, "SPECS");
        specs.mkdirs();
        File srpms = new File(this.topDir, "SRPMS");
        srpms.mkdirs();
        try {
            temps = new File(this.topDir, "tmp/" + this.rpmInfoFormatter.formatRpmNameWithoutVersion(this.project) + "-root/" + this.prefix);
        }
        catch (RpmFormattingException e) {
            throw new MojoExecutionException("Cannot read OS arch from rpm command.", (Exception)e);
        }
        temps.mkdirs();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class RpmrcParsingConsumer
    implements StreamConsumer {
        private String headerName;
        private String headerValue;

        RpmrcParsingConsumer(String headerName) {
            this.headerName = headerName;
        }

        public void consumeLine(String line) {
            BuildRpmMojo.this.getLog().debug((CharSequence)line);
            if (line.startsWith(this.headerName)) {
                int firstColonIdx = line.indexOf(58);
                this.headerValue = line.substring(firstColonIdx + 1).trim();
            }
        }

        public List<String> getValueList() {
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(this.headerValue, ":");
            while (tokens.hasMoreTokens()) {
                result.add(tokens.nextToken());
            }
            return result;
        }

        public String getValue() {
            return this.headerValue;
        }
    }
}

