/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class PackageRmiMojo
extends AbstractMojo {
    private File target;
    private String finalName;
    private MavenProject project;
    private String classifier;
    private File outputDirectory;
    private String[] includes;
    private String[] excludes;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.includes == null) {
            this.includes = new String[]{"**/*_Stub.class"};
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        File stubJar = new File(this.target, this.finalName + "-" + this.classifier + ".jar");
        JarArchiver jarArchiver = new JarArchiver();
        jarArchiver.setDestFile(stubJar);
        try {
            jarArchiver.addDirectory(this.outputDirectory, this.includes, this.excludes);
            this.getLog().info((CharSequence)("Building RMI stub jar: " + stubJar.getAbsolutePath()));
            jarArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not create the RMI stub jar", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create the RMI stub jar", (Exception)e);
        }
        this.projectHelper.attachArtifact(this.project, "jar", this.classifier, stubJar);
    }
}

