/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pde;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.pde.AbstractEclipsePDEMojo;
import org.codehaus.mojo.pde.descriptor.DescriptorUtil;
import org.codehaus.mojo.pde.descriptor.FeatureDescriptor;
import org.codehaus.mojo.pde.descriptor.ProductDescriptor;
import org.codehaus.plexus.util.cli.Commandline;

public class EclipsePDEMojo
extends AbstractEclipsePDEMojo {
    protected File pdeBuildTempFolder;
    private Map buildProperties = new Properties();
    private Map eclipseBuildScriptProperties = new Properties();

    protected void initialize() throws MojoExecutionException, MojoFailureException {
        super.initialize();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.pdeProductFilename == null) {
            this.executeCommandLine(this.createBootstrapCommandLine());
        }
        this.executeCommandLine(this.createBuildCommandLine());
    }

    protected Commandline createBuildCommandLine() throws MojoExecutionException {
        Commandline cl = null;
        cl = this.pdeProductFilename != null ? this.createProductBuildCommandLine() : this.createFeatureBuildCommandLine();
        cl.createArgument().setLine("-DbuildTempFolder=" + this.pdeBuildTempFolder);
        if (this.buildProperties.get("javacFailOnError") == null) {
            this.buildProperties.put("javacFailOnError", "true");
        }
        Iterator iter = this.buildProperties.entrySet().iterator();
        while (iter.hasNext()) {
            String arg = iter.next().toString();
            cl.createArgument().setLine("-D" + arg);
        }
        return cl;
    }

    private Commandline createProductBuildCommandLine() throws MojoExecutionException {
        File buildFile = new File(this.eclipseInstall, "plugins/org.eclipse.pde.build_" + this.pdeBuildVersion + "/scripts/productBuild/productBuild.xml");
        Commandline cl = this.createCommandLine(buildFile);
        File buildConfigDirectory = new File(this.pdeDirectory, this.pdeBuildConfigDirectory);
        try {
            cl.createArgument().setLine("-Dbuilder=" + buildConfigDirectory.getCanonicalPath());
            cl.createArgument().setLine("-DbuildDirectory=" + this.getPDEBuildDirectory().getPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("createProductBuildCommandLine failed: ", (Exception)e);
        }
        return cl;
    }

    private Commandline createFeatureBuildCommandLine() {
        Commandline cl = this.createCommandLine(new File(this.pdeDirectory, "build.xml"), this.getAntTarget());
        return cl;
    }

    protected File locateAntOutputFile() throws MojoExecutionException {
        if (this.descriptor instanceof ProductDescriptor) {
            String config = this.convertPdeConfigsToFilenameSuffix(this.buildConfigurationProperties.getString("configs"));
            return new File(this.getPDEBuildDirectory(), this.buildConfigurationProperties.getString("buildLabel") + "/" + this.buildConfigurationProperties.getProperty("buildId") + "-" + config + ".zip");
        }
        if (this.descriptor instanceof FeatureDescriptor) {
            return new File(this.pdeDirectory, this.descriptor.getId() + "_" + this.descriptor.getVersion() + ".bin.dist.zip");
        }
        return new File(this.pdeDirectory, this.descriptor.getId() + "_" + this.descriptor.getVersion() + ".zip");
    }

    private String getAntTarget() {
        String targets = "clean build.jars zip.plugin";
        if (this.descriptor instanceof FeatureDescriptor) {
            targets = "clean build.jars zip.distribution";
        }
        return targets;
    }

    private File createBootstrapAntFile() throws MojoExecutionException {
        File bootstrapFile = new File(this.project.getBuild().getDirectory() + "/pdeBuilder/build.xml");
        bootstrapFile.getParentFile().mkdirs();
        if (this.eclipseBuildScriptProperties.get("buildDirectory") == null) {
            this.eclipseBuildScriptProperties.put("buildDirectory", this.getPDEBuildDirectory().getPath());
        }
        if (this.eclipseBuildScriptProperties.get("baseLocation") == null) {
            this.eclipseBuildScriptProperties.put("baseLocation", this.getBaseLocation().getPath());
        }
        try {
            PrintStream out = new PrintStream(new FileOutputStream(bootstrapFile));
            out.println();
            out.println("<project default=\"generate\" > ");
            out.println("  <target name=\"generate\" >");
            out.println("    <eclipse.buildScript ");
            out.println("      elements=\"" + DescriptorUtil.getPDEType(this.descriptor) + "@" + this.descriptor.getId() + "\"");
            Iterator iter = this.eclipseBuildScriptProperties.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                String value = (String)this.eclipseBuildScriptProperties.get(key);
                out.println("      " + key + "=\"" + value + "\"");
            }
            out.println("    />");
            out.println("  </target>");
            out.println("</project>");
            out.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating bootstrap file: " + bootstrapFile);
        }
        return bootstrapFile;
    }

    protected Commandline createBootstrapCommandLine() throws MojoExecutionException {
        if (this.pdeProductFilename != null) {
            throw new MojoExecutionException("A Product Build does not require bootstrapping.");
        }
        File bootstrapFile = this.createBootstrapAntFile();
        return this.createCommandLine(bootstrapFile);
    }
}

