/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.license.api.ThirdPartyDetails;

public class DefaultThirdPartyDetails
implements ThirdPartyDetails {
    private String[] pomLicenses;
    private String[] thirdPartyLicenses;
    private final MavenProject project;

    public DefaultThirdPartyDetails(MavenProject project) {
        this.project = project;
    }

    @Override
    public String getGroupId() {
        return this.project.getArtifact().getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.project.getArtifact().getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.project.getArtifact().getVersion();
    }

    @Override
    public String getType() {
        return this.project.getArtifact().getType();
    }

    @Override
    public String getClassifier() {
        return this.project.getArtifact().getClassifier();
    }

    @Override
    public String getScope() {
        return this.project.getArtifact().getScope();
    }

    @Override
    public boolean hasPomLicenses() {
        return this.pomLicenses != null && this.pomLicenses.length > 0;
    }

    @Override
    public String[] getLicenses() {
        String[] result = null;
        if (this.hasPomLicenses()) {
            result = this.getPomLicenses();
        } else if (this.hasThirdPartyLicenses()) {
            result = this.getThirdPartyLicenses();
        }
        return result;
    }

    @Override
    public boolean hasLicenses() {
        return this.hasPomLicenses() || this.hasThirdPartyLicenses();
    }

    @Override
    public String[] getPomLicenses() {
        return this.pomLicenses;
    }

    @Override
    public void setPomLicenses(String[] pomLicenses) {
        this.pomLicenses = pomLicenses;
    }

    @Override
    public String[] getThirdPartyLicenses() {
        return this.thirdPartyLicenses;
    }

    @Override
    public boolean hasThirdPartyLicenses() {
        return this.thirdPartyLicenses != null && this.thirdPartyLicenses.length > 0;
    }

    @Override
    public void setThirdPartyLicenses(String[] thirdPartyLicenses) {
        this.thirdPartyLicenses = thirdPartyLicenses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultThirdPartyDetails that = (DefaultThirdPartyDetails)o;
        return new EqualsBuilder().append((Object)this.getGroupId(), (Object)that.getGroupId()).append((Object)this.getArtifactId(), (Object)that.getArtifactId()).append((Object)this.getVersion(), (Object)that.getVersion()).append((Object)this.getClassifier(), (Object)that.getClassifier()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getGroupId()).append((Object)this.getArtifactId()).append((Object)this.getVersion()).append((Object)this.getClassifier()).toHashCode();
    }
}

