/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.lesscss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:lesscss-maven-plugin:1.0-beta-3", 0);
        this.append(sb, "", 0);
        this.append(sb, "LESS CSS Maven Plugin", 0);
        this.append(sb, "The LESS CSS Maven Plugin is used to compile the LESS sources of your project to CSS stylesheets.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "compile".equals(this.goal)) {
            this.append(sb, "lesscss:compile", 0);
            this.append(sb, "Goal which compiles the LESS sources to CSS stylesheets.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compress (Default: false)", 2);
                this.append(sb, "When true the LESS compiler will compress the CSS stylesheets.", 3);
                this.append(sb, "Expression: ${lesscss.compress}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding the LESS compiler will use for writing the CSS stylesheets.", 3);
                this.append(sb, "Expression: ${lesscss.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the source directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "When true forces the LESS compiler to always compile the LESS sources. By default LESS sources are only compiled when modified (including imports) or the CSS stylesheet does not exists.", 3);
                this.append(sb, "Expression: ${lesscss.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the source directory. Default value is: { '**\\/*.less' }", 3);
                this.append(sb, "", 0);
                this.append(sb, "lessJs", 2);
                this.append(sb, "The location of the LESS JavasSript file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory for compiled CSS stylesheets.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${lesscss.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${project.basedir}/src/main/less)", 2);
                this.append(sb, "The source directory containing the LESS sources.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${lesscss.sourceDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "lesscss:help", 0);
            this.append(sb, "Display help information on lesscss-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0lesscss:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "lesscss:list", 0);
            this.append(sb, "Goal which list the LESS sources and its imports.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "List of files to exclude. Specified as fileset patterns which are relative to the source directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "List of files to include. Specified as fileset patterns which are relative to the source directory. Default value is: { '**\\/*.less' }", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${project.basedir}/src/main/less)", 2);
                this.append(sb, "The source directory containing the LESS sources.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${lesscss.sourceDirectory}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

