/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestMojo;
import org.codehaus.mojo.keytool.KeyToolRequestWithKeyStoreParameters;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyToolRequestWithKeyStoreParametersMojo<R extends KeyToolRequestWithKeyStoreParameters>
extends AbstractKeyToolRequestMojo<R> {
    @Parameter
    private String keystore;
    @Parameter
    private String storetype;
    @Parameter(alias="storepass")
    private String storepass;
    @Parameter
    private String providername;
    @Parameter
    private String providerclass;
    @Parameter
    private String providerarg;
    @Parameter
    private String providerpath;

    public AbstractKeyToolRequestWithKeyStoreParametersMojo(Class<R> requestType) {
        super(requestType);
    }

    @Override
    protected R createKeytoolRequest() {
        KeyToolRequestWithKeyStoreParameters request = (KeyToolRequestWithKeyStoreParameters)super.createKeytoolRequest();
        if (StringUtils.isNotEmpty((String)this.keystore)) {
            File file = this.getFile(this.keystore);
            boolean mkdirs = file.getParentFile().mkdirs();
            this.getLog().debug((CharSequence)("mdkirs: " + mkdirs + " " + file.getParentFile()));
            request.setKeystore(file.getAbsolutePath());
        }
        request.setProviderarg(this.providerarg);
        request.setProviderclass(this.providerclass);
        request.setProvidername(this.providername);
        request.setProviderpath(this.providerpath);
        request.setStorepass(this.storepass);
        request.setStoretype(this.storetype);
        return (R)request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.storepass, (String)"'*****'");
        return commandLineInfo;
    }

    protected final void createParentDirIfNecessary(String file) {
        File fileDir;
        if (file != null && (fileDir = new File(file).getParentFile()) != null) {
            boolean mkdirs = fileDir.mkdirs();
            this.getLog().debug((CharSequence)("mdkirs: " + mkdirs + " " + fileDir));
        }
    }

    protected File getFile(String path) {
        try {
            return new File(new File(path).toURL().getFile());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not obtain directory " + path);
        }
    }

    protected File getKeystoreFile() {
        return this.getFile(this.keystore);
    }
}

