/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.mojo.keytool.AbstractKeyToolCommandLineBuilder;
import org.codehaus.mojo.keytool.CommandLineConfigurationException;
import org.codehaus.mojo.keytool.KeyToolCommandLineBuilder;
import org.codehaus.mojo.keytool.KeyToolRequest;
import org.codehaus.mojo.keytool.UnsupportedKeyToolRequestException;
import org.codehaus.mojo.keytool.requests.KeyToolChangeAliasRequest;
import org.codehaus.mojo.keytool.requests.KeyToolChangeKeyPasswordRequest;
import org.codehaus.mojo.keytool.requests.KeyToolChangeStorePasswordRequest;
import org.codehaus.mojo.keytool.requests.KeyToolDeleteRequest;
import org.codehaus.mojo.keytool.requests.KeyToolExportCertificateRequest;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateCertificateRequest;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateCertificateRequestRequest;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateKeyPairRequest;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateSecretKeyRequest;
import org.codehaus.mojo.keytool.requests.KeyToolImportCertificateRequest;
import org.codehaus.mojo.keytool.requests.KeyToolImportKeystoreRequest;
import org.codehaus.mojo.keytool.requests.KeyToolListRequest;
import org.codehaus.mojo.keytool.requests.KeyToolPrintCRLFileRequest;
import org.codehaus.mojo.keytool.requests.KeyToolPrintCertificateRequest;
import org.codehaus.mojo.keytool.requests.KeyToolPrintCertificateRequestRequest;
import org.codehaus.plexus.component.annotations.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=KeyToolCommandLineBuilder.class, hint="default")
public class DefaultKeyToolCommandLineBuilder
extends AbstractKeyToolCommandLineBuilder {
    final Set<Class<? extends KeyToolRequest>> unsupportedRequestTypes = new HashSet<Class<? extends KeyToolRequest>>();

    public DefaultKeyToolCommandLineBuilder() {
        this.unsupportedRequestTypes.add(KeyToolGenerateCertificateRequest.class);
        this.unsupportedRequestTypes.add(KeyToolPrintCertificateRequestRequest.class);
        this.unsupportedRequestTypes.add(KeyToolPrintCRLFileRequest.class);
    }

    public <R extends KeyToolRequest> boolean supportRequestType(Class<R> requestType) {
        return !this.unsupportedRequestTypes.contains(requestType);
    }

    public Commandline build(KeyToolRequest request) throws CommandLineConfigurationException, UnsupportedKeyToolRequestException {
        String[] arguments;
        this.checkRequiredState();
        this.checkSupportedRequest(request);
        Commandline cli = new Commandline();
        cli.setExecutable(this.getKeyToolFile());
        cli.setWorkingDirectory(request.getWorkingDirectory());
        if (request instanceof KeyToolChangeAliasRequest) {
            this.build((KeyToolChangeAliasRequest)request, cli);
        }
        if (request instanceof KeyToolChangeKeyPasswordRequest) {
            this.build((KeyToolChangeKeyPasswordRequest)request, cli);
        }
        if (request instanceof KeyToolChangeStorePasswordRequest) {
            this.build((KeyToolChangeStorePasswordRequest)request, cli);
        }
        if (request instanceof KeyToolDeleteRequest) {
            this.build((KeyToolDeleteRequest)request, cli);
        }
        if (request instanceof KeyToolExportCertificateRequest) {
            this.build((KeyToolExportCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateCertificateRequest) {
            this.build((KeyToolGenerateCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateCertificateRequestRequest) {
            this.build((KeyToolGenerateCertificateRequestRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateKeyPairRequest) {
            this.build((KeyToolGenerateKeyPairRequest)request, cli);
        }
        if (request instanceof KeyToolGenerateSecretKeyRequest) {
            this.build((KeyToolGenerateSecretKeyRequest)request, cli);
        }
        if (request instanceof KeyToolImportCertificateRequest) {
            this.build((KeyToolImportCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolImportKeystoreRequest) {
            this.build((KeyToolImportKeystoreRequest)request, cli);
        }
        if (request instanceof KeyToolListRequest) {
            this.build((KeyToolListRequest)request, cli);
        }
        if (request instanceof KeyToolPrintCertificateRequest) {
            this.build((KeyToolPrintCertificateRequest)request, cli);
        }
        if (request instanceof KeyToolPrintCertificateRequestRequest) {
            this.build((KeyToolPrintCertificateRequestRequest)request, cli);
        }
        if (request instanceof KeyToolPrintCRLFileRequest) {
            this.build((KeyToolPrintCRLFileRequest)request, cli);
        }
        if ((arguments = request.getArguments()) != null) {
            cli.addArguments(arguments);
        }
        return cli;
    }

    protected void build(KeyToolChangeAliasRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-changealias", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-destalias", request.getDestalias());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
    }

    protected void build(KeyToolChangeKeyPasswordRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-keypasswd", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-new", request.getNewPassword());
    }

    protected void build(KeyToolChangeStorePasswordRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-storepasswd", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-new", request.getNewPassword());
    }

    protected void build(KeyToolDeleteRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-delete", (KeyToolRequest)request);
    }

    protected void build(KeyToolExportCertificateRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-export", (KeyToolRequest)request);
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
    }

    protected void build(KeyToolGenerateCertificateRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-gencert", (KeyToolRequest)request);
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
        this.addArgIfNotEmpty(cli, "-infile", request.getInfile());
        this.addArgIfNotEmpty(cli, "-outfile", request.getOutfile());
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
        this.addArgIfNotEmpty(cli, "-startdate", request.getStartdate());
        this.addArgIfNotEmpty(cli, "-ext", request.getExt());
        this.addArgIfNotEmpty(cli, "-validity", request.getValidity());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
    }

    protected void build(KeyToolGenerateCertificateRequestRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-certreq", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
    }

    protected void build(KeyToolGenerateKeyPairRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-genkeypair", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-validity", request.getValidity());
        this.addArgIfNotEmpty(cli, "-keyalg", request.getKeyalg());
        this.addArgIfNotEmpty(cli, "-keysize", request.getKeysize());
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-startdate", request.getStartdate());
        this.addArgIfNotEmpty(cli, "-ext", request.getExt());
    }

    protected void build(KeyToolGenerateSecretKeyRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-genseckey", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-keyalg", request.getKeyalg());
        this.addArgIfNotEmpty(cli, "-keysize", request.getKeysize());
    }

    protected void build(KeyToolImportCertificateRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-importcert", (KeyToolRequest)request);
        this.addArgIfTrue(cli, "-noprompt", request.isNoprompt());
        this.addArgIfTrue(cli, "-trustcacerts", request.isTrustcacerts());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
    }

    protected void build(KeyToolImportKeystoreRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-importkeystore", (KeyToolRequest)request);
        this.addArgIfTrue(cli, "-noprompt", request.isNoprompt());
        this.addArgIfNotEmpty(cli, "-srcprotected", request.isSrcprotected() ? Boolean.TRUE.toString() : "");
        this.addArgIfNotEmpty(cli, "-srckeystore", request.getSrckeystore());
        this.addArgIfNotEmpty(cli, "-destkeystore", request.getDestkeystore());
        this.addArgIfNotEmpty(cli, "-srcstoretype", request.getSrcstoretype());
        this.addArgIfNotEmpty(cli, "-deststoretype", request.getDeststoretype());
        this.addArgIfNotEmpty(cli, "-srcstorepass", request.getSrcstorepass());
        this.addArgIfNotEmpty(cli, "-deststorepass", request.getDeststorepass());
        this.addArgIfNotEmpty(cli, "-srcprovidername", request.getSrcprovidername());
        this.addArgIfNotEmpty(cli, "-destprovidername", request.getDestprovidername());
        this.addArgIfNotEmpty(cli, "-srcalias", request.getSrcalias());
        this.addArgIfNotEmpty(cli, "-destalias", request.getDestalias());
        this.addArgIfNotEmpty(cli, "-srckeypass", request.getSrckeypass());
        this.addArgIfNotEmpty(cli, "-destkeypass", request.getDestkeypass());
        this.addArgIfNotEmpty(cli, "-providerclass", request.getProviderclass());
        this.addArgIfNotEmpty(cli, "-providerarg", request.getProviderarg());
        this.addArgIfNotEmpty(cli, "-providerpath", request.getProviderpath());
    }

    protected void build(KeyToolListRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-list", (KeyToolRequest)request);
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
    }

    protected void build(KeyToolPrintCertificateRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-printcert", (KeyToolRequest)request);
        this.addArgIfTrue(cli, "-rfc", request.isRfc());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-sslserver", request.getSslserver());
        this.addArgIfNotEmpty(cli, "-jarfile", request.getJarfile());
    }

    protected void build(KeyToolPrintCertificateRequestRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-printcertreq", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
    }

    protected void build(KeyToolPrintCRLFileRequest request, Commandline cli) {
        this.addKeytoolCommandAndDefaultoptions(cli, "-printcrl", (KeyToolRequest)request);
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
    }
}

