/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jsimport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:js-import-maven-plugin:1.0.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "JavaScript Import Maven Plugin", 0);
        this.append(sb, "Provides tooling for managing JavaScript dependencies.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate-html".equals(this.goal)) {
            this.append(sb, "js-import:generate-html", 0);
            this.append(sb, "Main goal implementation of the generate html mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering resources.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Files to exclude. Nothing is excluded by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Files to include. Defaults to '**\\/*.html,**\\/*.htm'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceHtmlFolder (Default: ${basedir}/src/main/resources)", 2);
                this.append(sb, "The HTML resource folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceJsFolder (Default: ${basedir}/src/main/js)", 2);
                this.append(sb, "The JavaScript source folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetFolder (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The project target folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetJsPath (Default: js)", 2);
                this.append(sb, "The target path for js files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "workFolder (Default: ${project.build.directory}/ImportMojo/main)", 2);
                this.append(sb, "The folder where test files are created that assist with multiple invocations e.g. caches.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "js-import:help", 0);
            this.append(sb, "Display help information on js-import-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0js-import:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "import-js".equals(this.goal)) {
            this.append(sb, "js-import:import-js", 0);
            this.append(sb, "Main goal implementation of the import mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "assumeABrowser (Default: true)", 2);
                this.append(sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser TODO: Provide the other JSLint 'assume' options.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Files to exclude. Nothing is excluded by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Files to include. Defaults to '**\\/*.js'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceJsFolder (Default: ${basedir}/src/main/js)", 2);
                this.append(sb, "Source JavaScript folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetFolder (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The project target folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "workFolder (Default: ${project.build.directory}/ImportMojo/main)", 2);
                this.append(sb, "The folder where files are created that assist with multiple invocations e.g. caches.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-generate-html".equals(this.goal)) {
            this.append(sb, "js-import:test-generate-html", 0);
            this.append(sb, "Test goal implementation of the generate html mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering resources.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Files to exclude. Nothing is excluded by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Files to include. Defaults to '**\\/*.html,**\\/*.htm'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainSourceJsFolder (Default: ${basedir}/src/main/js)", 2);
                this.append(sb, "The JavaScript main source folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "mainTargetFolder (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The main project target folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "resourceHtmlFolder (Default: ${basedir}/src/test/resources)", 2);
                this.append(sb, "The HTML test resource folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceJsFolder (Default: ${basedir}/src/test/js)", 2);
                this.append(sb, "The JavaScript test source folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetFolder (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "The project target folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetJsPath (Default: js)", 2);
                this.append(sb, "The target path for js files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "workFolder (Default: ${project.build.directory}/ImportMojo/test)", 2);
                this.append(sb, "The folder where test files are created that assist with multiple invocations e.g. caches.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-import-js".equals(this.goal)) {
            this.append(sb, "js-import:test-import-js", 0);
            this.append(sb, "Test goal implementation of the import mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "assumeABrowser (Default: true)", 2);
                this.append(sb, "true if the standard browser globals should be predefined. @see http://www.jslint.com/lint.html#browser TODO: Provide the other JSLint 'assume' options.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Files to exclude. Nothing is excluded by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Files to include. Defaults to '**\\/*.js'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceJsFolder (Default: ${basedir}/src/test/js)", 2);
                this.append(sb, "The test source folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetFolder (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "The project target folder.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "workFolder (Default: ${project.build.directory}/ImportMojo/test)", 2);
                this.append(sb, "The folder where test files are created that assist with multiple invocations e.g. caches.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

