/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ruby.extractor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.plugin.descriptor.DuplicateParameterException;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.tools.plugin.extractor.AbstractScriptedMojoDescriptorExtractor;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.codehaus.plexus.component.jruby.JRubyRuntimeInvoker;
import org.codehaus.plexus.util.StringOutputStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyExtractor
extends AbstractScriptedMojoDescriptorExtractor {
    protected List extractMojoDescriptors(Map scriptFilesKeyedByBasedir, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        ArrayList<MojoDescriptor> descriptors = new ArrayList<MojoDescriptor>();
        Iterator mapIterator = scriptFilesKeyedByBasedir.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = mapIterator.next();
            String basedir = (String)entry.getKey();
            Set metadataFiles = (Set)entry.getValue();
            Iterator it = metadataFiles.iterator();
            while (it.hasNext()) {
                File scriptFile = (File)it.next();
                String relativePath = null;
                if (basedir.endsWith("/")) {
                    basedir = basedir.substring(0, basedir.length() - 2);
                }
                relativePath = scriptFile.getPath().substring(basedir.length());
                relativePath = relativePath.replace('\\', '/');
                MojoDescriptor mojoDescriptor = this.createMojoDescriptor(basedir, relativePath, pluginDescriptor);
                descriptors.add(mojoDescriptor);
            }
        }
        return descriptors;
    }

    private MojoDescriptor createMojoDescriptor(String basedir, String resource, PluginDescriptor pluginDescriptor) throws InvalidPluginDescriptorException {
        MojoDescriptor mojoDescriptor = new MojoDescriptor();
        mojoDescriptor.setPluginDescriptor(pluginDescriptor);
        mojoDescriptor.setLanguage("jruby-mojo");
        mojoDescriptor.setComponentConfigurator("jruby");
        mojoDescriptor.setImplementation(resource);
        this.getLogger().info("Ruby Mojo File: " + resource);
        try {
            IRubyObject fields;
            FileInputStream extractor = new FileInputStream(new File(basedir, resource).getAbsolutePath());
            JRubyRuntimeInvoker invoker = new JRubyRuntimeInvoker((Reader)new InputStreamReader(extractor));
            invoker.setRequires(new String[]{"inline_extractor.rb"});
            StringOutputStream stdout = new StringOutputStream();
            StringOutputStream stderr = new StringOutputStream();
            Map map = (Map)invoker.invoke();
            this.logOutput(stdout.toString(), false);
            this.logOutput(stderr.toString(), true);
            Ruby runtime = Ruby.getDefaultInstance();
            String goal = this.getParameter(runtime, map, "goal");
            if (goal == null) {
                throw new InvalidPluginDescriptorException("Cannot create plugin descriptor. Goal is a required value for a Mojo");
            }
            mojoDescriptor.setGoal(goal);
            mojoDescriptor.setPhase(this.getParameter(runtime, map, "phase"));
            mojoDescriptor.setDependencyResolutionRequired(this.getParameter(runtime, map, "requiresDependencyResolution"));
            mojoDescriptor.setDescription(this.getParameter(runtime, map, "description"));
            IRubyObject executes = (IRubyObject)map.get(RubyString.newString((Ruby)runtime, (CharSequence)"execute"));
            if (executes != null && !executes.isNil()) {
                RubyHash executesMap = (RubyHash)executes;
                mojoDescriptor.setExecutePhase(this.getParameter(runtime, (Map)executesMap, "phase"));
                mojoDescriptor.setExecuteLifecycle(this.getParameter(runtime, (Map)executesMap, "lifecycle"));
                mojoDescriptor.setExecuteGoal(this.getParameter(runtime, (Map)executesMap, "goal"));
            }
            if ((fields = (IRubyObject)map.get(RubyString.newString((Ruby)runtime, (CharSequence)"fields"))) != null && !fields.isNil()) {
                RubyArray fieldsList = (RubyArray)fields;
                Iterator iter = fieldsList.iterator();
                while (iter.hasNext()) {
                    RubyHash field = (RubyHash)iter.next();
                    this.setParameter(runtime, (Map)field, mojoDescriptor);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("", (Throwable)e);
        }
        return mojoDescriptor;
    }

    private String getParameter(Ruby runtime, Map params, String annotation) {
        Object param = params.get(RubyString.newString((Ruby)runtime, (CharSequence)annotation));
        if (param instanceof String) {
            return (String)param;
        }
        IRubyObject anno = (IRubyObject)param;
        if (anno != null && !anno.isNil()) {
            return anno.toString();
        }
        return null;
    }

    private void setParameter(Ruby runtime, Map field, MojoDescriptor mojoDescriptor) throws DuplicateParameterException {
        String name = this.getParameter(runtime, field, "name");
        if (name == null) {
            throw new NullPointerException("Expected a non-null value for a declared parameter name");
        }
        Parameter param = new Parameter();
        param.setName(name);
        param.setRequired("true".equals(this.getParameter(runtime, field, "required")));
        param.setEditable(!"true".equals(this.getParameter(runtime, field, "readonly")));
        param.setDeprecated(this.getParameter(runtime, field, "deprecated"));
        param.setDescription(this.getParameter(runtime, field, "description"));
        param.setType(this.getParameter(runtime, field, "type"));
        param.setAlias(this.getParameter(runtime, field, "alias"));
        param.setDefaultValue(this.getParameter(runtime, field, "default"));
        param.setExpression(this.getParameter(runtime, field, "expression"));
        mojoDescriptor.addParameter(param);
    }

    protected String getScriptFileExtension() {
        return "rb";
    }

    private void logOutput(String output, boolean error) {
        if (output != null && output.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(output, "\n");
            while (tokens.hasMoreTokens()) {
                if (error) {
                    this.getLogger().error(tokens.nextToken());
                    continue;
                }
                this.getLogger().info(tokens.nextToken());
            }
        }
    }
}

