/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jboss.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractPackagingMojo
extends AbstractMojo {
    private MavenProject project;
    private File outputDirectory;
    private File classesDirectory;
    private File packagingDirectory;
    protected File deploymentDescriptorFile;
    private File libDirectory;
    private String archiveName;
    private boolean excludeAll;
    private Set excludes;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File manifest;
    private String classifier;
    private boolean primaryArtifact;
    private MavenProjectHelper projectHelper;
    private ArtifactHandlerManager artifactHandlerManager;

    public MavenProject getProject() {
        return this.project;
    }

    public File getPackagingDirectory() {
        return this.packagingDirectory;
    }

    public abstract String getDeploymentDescriptorFilename();

    public abstract String getArtifactType();

    public String[] getAlternateDeploymentDescriptorFilenames() {
        return null;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void buildExplodedPackaging() throws MojoExecutionException, MojoFailureException {
        this.buildExplodedPackaging(Collections.EMPTY_SET);
    }

    public void buildExplodedPackaging(Set excludes) throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Exploding JBoss packaging...");
        if (excludes == null) {
            excludes = Collections.EMPTY_SET;
        }
        this.packagingDirectory.mkdirs();
        this.libDirectory.mkdirs();
        try {
            File packagingFileTargetParent;
            File packagingFileTarget;
            this.getLog().info((CharSequence)("Assembling JBoss packaging " + this.project.getArtifactId() + " in " + this.packagingDirectory));
            if (this.classesDirectory.exists() && !this.classesDirectory.equals(this.packagingDirectory)) {
                FileUtils.copyDirectoryStructure((File)this.classesDirectory, (File)this.packagingDirectory);
            }
            if (!(packagingFileTarget = new File(packagingFileTargetParent = new File(this.packagingDirectory, "META-INF"), this.getDeploymentDescriptorFilename())).exists()) {
                if (!packagingFileTargetParent.exists()) {
                    packagingFileTargetParent.mkdirs();
                }
                if (this.deploymentDescriptorFile == null || !this.deploymentDescriptorFile.exists()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(this.getDeploymentDescriptorFilename());
                    String[] alternateDescriptorFilenames = this.getAlternateDeploymentDescriptorFilenames();
                    if (alternateDescriptorFilenames != null) {
                        for (int i = 0; i < alternateDescriptorFilenames.length; ++i) {
                            buffer.append(", ");
                            buffer.append(alternateDescriptorFilenames[i]);
                            this.deploymentDescriptorFile = new File(packagingFileTargetParent, alternateDescriptorFilenames[i]);
                            if (this.deploymentDescriptorFile != null && this.deploymentDescriptorFile.exists()) break;
                        }
                    }
                    if (this.deploymentDescriptorFile == null || !this.deploymentDescriptorFile.exists()) {
                        throw new MojoExecutionException("Could not find descriptor files: " + buffer.toString());
                    }
                }
                FileUtils.copyFile((File)this.deploymentDescriptorFile, (File)packagingFileTarget);
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Artifact> rejects = new ArrayList<Artifact>();
            HashSet<String> includedArtifacts = new HashSet<String>();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"    Including artifacts: ");
            this.getLog().info((CharSequence)"    -------------------");
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                if (artifact.isOptional() || !filter.include(artifact)) continue;
                String descriptor = artifact.getGroupId() + ":" + artifact.getArtifactId();
                if (!this.excludeAll && artifact.getArtifactHandler().isAddedToClasspath() && !excludes.contains(descriptor)) {
                    this.getLog().info((CharSequence)("        o " + descriptor));
                    String name = AbstractPackagingMojo.getArtifactName(artifact);
                    if (!includedArtifacts.add(name)) {
                        name = artifact.getGroupId() + "-" + name;
                        this.getLog().debug((CharSequence)("Duplicate artifact discovered, using full name: " + name));
                    }
                    FileUtils.copyFile((File)artifact.getFile(), (File)new File(this.libDirectory, name));
                    continue;
                }
                rejects.add(artifact);
            }
            if (!excludes.isEmpty()) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"    Excluded artifacts: ");
                this.getLog().info((CharSequence)"    ------------------");
                for (int ii = 0; ii < rejects.size(); ++ii) {
                    this.getLog().info((CharSequence)("        o " + rejects.get(ii)));
                }
            } else {
                this.getLog().info((CharSequence)"No artifacts have been excluded.");
            }
            this.getLog().info((CharSequence)"");
            this.buildSpecificPackaging(excludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode JBoss packaging...", (Exception)e);
        }
    }

    protected void buildSpecificPackaging(Set excludes) throws MojoExecutionException, MojoFailureException, IOException {
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    protected void performPackaging() throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException, MojoFailureException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(this.getArtifactType());
        String extension = artifactHandler.getExtension();
        String type = this.getArtifactType();
        File archiveFile = AbstractPackagingMojo.calculateFile(this.outputDirectory, this.archiveName, this.classifier, extension);
        this.buildExplodedPackaging(this.excludes);
        this.getLog().info((CharSequence)("Generating JBoss packaging " + archiveFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        this.jarArchiver.addDirectory(this.getPackagingDirectory());
        if (this.manifest != null) {
            this.jarArchiver.setManifest(this.manifest);
        }
        archiver.createArchive(this.getProject(), this.archive);
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, type, this.classifier, archiveFile);
        } else if (this.primaryArtifact) {
            Artifact artifact = this.project.getArtifact();
            artifact.setFile(archiveFile);
            artifact.setArtifactHandler(artifactHandler);
        }
    }

    private static File calculateFile(File outputDirectory, String archiveName, String classifier, String extension) {
        String basename = StringUtils.isEmpty((String)classifier) ? archiveName : archiveName + '-' + classifier;
        return new File(outputDirectory, basename + '.' + extension);
    }

    private static String getArtifactName(Artifact artifact) {
        String classifier = artifact.getClassifier();
        String artifactName = StringUtils.isEmpty((String)classifier) ? artifact.getArtifactId() + '-' + artifact.getVersion() + '.' + artifact.getArtifactHandler().getExtension() : artifact.getArtifactId() + '-' + artifact.getVersion() + '-' + classifier + '.' + artifact.getArtifactHandler().getExtension();
        return artifactName;
    }
}

