/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten.model.resolution;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;

public class FlattenModelResolver
implements ModelResolver {
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;

    public FlattenModelResolver(ArtifactRepository localRepository, ArtifactFactory artifactFactory) {
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, version);
        pomArtifact = this.localRepository.find(pomArtifact);
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    public void addRepository(Repository repository) {
    }

    public ModelResolver newCopy() {
        return new FlattenModelResolver(this.localRepository, this.artifactFactory);
    }

    public ModelSource resolveModel(Parent parent) {
        Artifact pomArtifact = this.artifactFactory.createProjectArtifact(parent.getGroupId(), parent.getArtifactId(), parent.getVersion());
        pomArtifact = this.localRepository.find(pomArtifact);
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    public void resetRepositories() {
    }

    public void addRepository(Repository repository, boolean replace) {
    }
}

