/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.chronos.common.ProjectBaseDir;
import org.codehaus.mojo.chronos.common.TestDataDirectory;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.report.ReportConfig;
import org.codehaus.mojo.chronos.report.ReportGenerator;
import org.codehaus.mojo.chronos.report.Utils;
import org.codehaus.mojo.chronos.report.chart.ChartRendererImpl;
import org.codehaus.mojo.chronos.report.chart.ChartUtil;
import org.codehaus.mojo.chronos.report.chart.GraphGenerator;
import org.jdom.JDOMException;

public class ReportMojo
extends AbstractMavenReport {
    private static final int DEFAULT_DURATION = 20000;
    protected String outputDirectory;
    protected SiteRenderer siteRenderer;
    public MavenProject project;
    protected String reportid;
    protected String dataid;
    protected String title;
    protected String description;
    protected int responsetimedivider = 1;
    protected int averageduration = 20000;
    protected int threadcountduration = 20000;
    protected boolean showsummary = true;
    protected boolean showsummarycharts = true;
    protected boolean showdetails = true;
    protected boolean showresponse = true;
    protected boolean showhistogram = true;
    protected boolean showthroughput = true;
    protected boolean showinfotable = true;
    protected boolean showtimeinfo = true;
    protected Boolean showpercentile;
    protected boolean showpercentile95 = true;
    protected boolean showpercentile99 = false;
    protected boolean showaverage = true;
    protected boolean showgc = true;
    protected double historychartupperbound = 0.0;
    protected String metadata;

    public void executeReport(Locale locale) throws MavenReportException {
        String dataId = this.getDataId();
        if (this.showpercentile != null) {
            this.getLog().warn((CharSequence)"Property showPercentile is deprecated. Value is ignored. Use showPercentile95 og showPercentile99 instead");
        }
        try {
            ProjectBaseDir projectBaseDir = new ProjectBaseDir(this.project.getBasedir(), this.getLog());
            TestDataDirectory testDataDirectory = projectBaseDir.getDataDirectory(dataId);
            GroupedResponsetimeSamples jmeterSamples = testDataDirectory.readResponsetimeSamples();
            if (jmeterSamples.size() == 0) {
                throw new MavenReportException("Response time samples not found for " + dataId);
            }
            this.getLog().info((CharSequence)("  tests: " + jmeterSamples.getSampleGroups().size()));
            this.getLog().info((CharSequence)("  jmeter samples: " + jmeterSamples.size()));
            this.getLog().info((CharSequence)" generating charts...");
            GCSamples gcSamples = testDataDirectory.readGCSamples();
            List defaultPlugins = ChartUtil.createDefaultPlugins(jmeterSamples, gcSamples);
            GraphGenerator graphGenerator = new GraphGenerator(defaultPlugins);
            ChartRendererImpl renderer = new ChartRendererImpl(this.getOutputDirectory());
            graphGenerator.generateGraphs(renderer, this.getBundle(locale), this.getConfig());
            ReportGenerator reportGenerator = new ReportGenerator(this.getBundle(locale), this.getConfig(), graphGenerator);
            this.getLog().info((CharSequence)" generating report...");
            Sink sink = this.getSink();
            reportGenerator.doGenerateReport(sink, jmeterSamples);
        }
        catch (IOException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)e);
        }
        catch (JDOMException e) {
            throw new MavenReportException("ReportGenerator failed", (Exception)((Object)e));
        }
    }

    private String getDataId() {
        return this.dataid;
    }

    public String getName(Locale locale) {
        return this.getOutputName();
    }

    public String getDescription(Locale locale) {
        return this.description;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public String getOutputName() {
        return this.getConfig().getId();
    }

    protected String getOutputDirectory() {
        return this.outputDirectory;
    }

    ResourceBundle getBundle(Locale locale) {
        return Utils.getBundle(locale);
    }

    public boolean canGenerateReport() {
        return true;
    }

    protected ReportConfig getConfig() {
        return new ReportConfig(){

            public String getId() {
                return ReportMojo.this.reportid != null ? ReportMojo.this.reportid : ReportMojo.this.dataid;
            }

            public String getTitle() {
                return ReportMojo.this.title;
            }

            public String getDescription() {
                return ReportMojo.this.description;
            }

            public int getAverageduration() {
                return ReportMojo.this.averageduration;
            }

            public long getThreadcountduration() {
                return ReportMojo.this.threadcountduration;
            }

            public double getHistoryChartUpperBound() {
                return ReportMojo.this.historychartupperbound;
            }

            public boolean isShowaverage() {
                return ReportMojo.this.showaverage;
            }

            public boolean isShowdetails() {
                return ReportMojo.this.showdetails;
            }

            public boolean isShowgc() {
                return ReportMojo.this.showgc;
            }

            public boolean isShowhistogram() {
                return ReportMojo.this.showhistogram;
            }

            public boolean isShowinfotable() {
                return ReportMojo.this.showinfotable;
            }

            public boolean isShowpercentile95() {
                return ReportMojo.this.showpercentile95;
            }

            public boolean isShowpercentile99() {
                return ReportMojo.this.showpercentile99;
            }

            public boolean isShowresponse() {
                return ReportMojo.this.showresponse;
            }

            public boolean isShowsummary() {
                return ReportMojo.this.showsummary;
            }

            public boolean isShowsummarycharts() {
                return ReportMojo.this.showsummarycharts;
            }

            public boolean isShowthroughput() {
                return ReportMojo.this.showthroughput;
            }

            public boolean isShowtimeinfo() {
                return ReportMojo.this.showtimeinfo;
            }

            public String getMetadata() {
                return ReportMojo.this.metadata;
            }
        };
    }
}

