/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;
import org.codehaus.mojo.buildhelper.versioning.DefaultVersioning;

@Mojo(name="parse-version", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ParseVersionMojo
extends AbstractDefinePropertyMojo {
    @Parameter(defaultValue="${project.version}")
    private String versionString;
    @Parameter(defaultValue="parsedVersion")
    private String propertyPrefix;
    @Parameter(defaultValue="formattedVersion")
    private String formattedPropertyPrefix;
    @Parameter(defaultValue="%02d")
    private String formatMajor;
    @Parameter(defaultValue="%02d")
    private String formatMinor;
    @Parameter(defaultValue="%02d")
    private String formatIncremental;
    @Parameter(defaultValue="%02d")
    private String formatBuildNumber;
    @Parameter(defaultValue="-")
    private String qualifierPrefix;

    public void execute() {
        this.parseVersion(this.versionString);
    }

    private void defineVersionProperty(String name, String value) {
        this.defineProperty(this.propertyPrefix + '.' + name, value);
    }

    private void defineFormattedVersionProperty(String name, String value) {
        this.defineProperty(this.formattedPropertyPrefix + '.' + name, value);
    }

    private void defineVersionProperty(String name, int value) {
        this.defineVersionProperty(name, Integer.toString(value));
    }

    private void defineVersionProperty(String name, long value) {
        this.defineVersionProperty(name, Long.toString(value));
    }

    public void parseVersion(String version) {
        DefaultVersioning artifactVersion = new DefaultVersioning(version);
        this.getLog().debug((CharSequence)"Parsed Version");
        this.getLog().debug((CharSequence)("         major: " + artifactVersion.getMajor()));
        this.getLog().debug((CharSequence)("         minor: " + artifactVersion.getMinor()));
        this.getLog().debug((CharSequence)("   incremental: " + artifactVersion.getPatch()));
        this.getLog().debug((CharSequence)("   buildnumber: " + artifactVersion.getBuildNumber()));
        this.getLog().debug((CharSequence)("     qualifier: " + artifactVersion.getQualifier()));
        this.defineVersionProperty("majorVersion", artifactVersion.getMajor());
        this.defineVersionProperty("minorVersion", artifactVersion.getMinor());
        this.defineVersionProperty("incrementalVersion", artifactVersion.getPatch());
        this.defineVersionProperty("buildNumber", artifactVersion.getBuildNumber());
        this.defineVersionProperty("nextMajorVersion", artifactVersion.getMajor() + 1);
        this.defineVersionProperty("nextMinorVersion", artifactVersion.getMinor() + 1);
        this.defineVersionProperty("nextIncrementalVersion", artifactVersion.getPatch() + 1);
        this.defineVersionProperty("nextBuildNumber", artifactVersion.getBuildNumber() + 1L);
        this.defineFormattedVersionProperty("majorVersion", String.format(this.formatMajor, artifactVersion.getMajor()));
        this.defineFormattedVersionProperty("minorVersion", String.format(this.formatMinor, artifactVersion.getMinor()));
        this.defineFormattedVersionProperty("incrementalVersion", String.format(this.formatIncremental, artifactVersion.getPatch()));
        this.defineFormattedVersionProperty("buildNumber", String.format(this.formatBuildNumber, artifactVersion.getBuildNumber()));
        this.defineFormattedVersionProperty("nextMajorVersion", String.format(this.formatMajor, artifactVersion.getMajor() + 1));
        this.defineFormattedVersionProperty("nextMinorVersion", String.format(this.formatMinor, artifactVersion.getMinor() + 1));
        this.defineFormattedVersionProperty("nextIncrementalVersion", String.format(this.formatIncremental, artifactVersion.getPatch() + 1));
        this.defineFormattedVersionProperty("nextBuildNumber", String.format(this.formatBuildNumber, artifactVersion.getBuildNumber() + 1L));
        String osgi = artifactVersion.getAsOSGiVersion();
        String qualifier = artifactVersion.getQualifier();
        String qualifierQuestion = "";
        if (qualifier == null) {
            qualifier = "";
        } else {
            qualifierQuestion = this.qualifierPrefix;
        }
        this.defineVersionProperty("qualifier", qualifier);
        this.defineVersionProperty("qualifier?", qualifierQuestion + qualifier);
        this.defineVersionProperty("osgiVersion", osgi);
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public void setFormattedPropertyPrefix(String formattedPropertyPrefix) {
        this.formattedPropertyPrefix = formattedPropertyPrefix;
    }

    public void setFormatMajor(String formatMajor) {
        this.formatMajor = formatMajor;
    }

    public void setFormatMinor(String formatMinor) {
        this.formatMinor = formatMinor;
    }

    public void setFormatIncremental(String formatIncremental) {
        this.formatIncremental = formatIncremental;
    }

    public void setFormatBuildNumber(String formatBuildNumber) {
        this.formatBuildNumber = formatBuildNumber;
    }
}

