/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.apt.AptUtils;
import org.codehaus.mojo.apt.CollectionUtils;
import org.codehaus.mojo.apt.LogUtils;
import org.codehaus.mojo.apt.MavenProjectUtils;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAptMojo
extends AbstractMojo {
    private MavenProject project;
    private List<Artifact> pluginArtifacts;
    private File workingDirectory;
    private boolean fork;
    private String executable;
    private String meminitial;
    private String maxmem;
    private boolean showWarnings;
    private String encoding;
    private boolean verbose;
    private String[] options;
    private String factory;
    private List<String> additionalSourceRoots;
    private Set<String> includes;
    private Set<String> excludes;
    private String resourceTargetPath;
    private boolean resourceFiltering;
    private boolean force;
    private Set<String> outputFiles;
    private Set<String> outputFileEndings;
    private int staleMillis;
    private boolean skip;
    private Set<String> effectiveIncludes;
    private Set<String> effectiveExcludes;

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping apt");
        } else {
            this.executeImpl();
        }
    }

    protected void executeImpl() throws MojoExecutionException {
        this.effectiveIncludes = CollectionUtils.defaultSet(this.includes, Collections.singleton("**/*.java"));
        this.effectiveExcludes = CollectionUtils.defaultSet(this.excludes);
        List<File> staleSourceFiles = this.getSourceFiles(this.getStaleScanner(), "stale sources");
        if (staleSourceFiles.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to process - all processor-generated files are up to date");
        } else {
            this.executeApt();
        }
        String sourcePath = this.getSourceOutputDirectory().getPath();
        if (!this.getCompileSourceRoots().contains(sourcePath)) {
            this.getCompileSourceRoots().add(sourcePath);
        }
        String resourcePath = this.getOutputDirectory().getPath();
        if (!MavenProjectUtils.containsDirectory(this.getResources(), resourcePath)) {
            Resource resource = new Resource();
            resource.setDirectory(resourcePath);
            resource.addExclude("**/*.java");
            resource.setFiltering(this.resourceFiltering);
            if (this.resourceTargetPath != null) {
                resource.setTargetPath(this.resourceTargetPath);
            }
            this.getResources().add(resource);
        }
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String[] getOptions() {
        return this.options;
    }

    protected abstract List<String> getCompileSourceRoots();

    protected abstract List<Resource> getResources();

    protected abstract List<String> getClasspathElements();

    protected abstract File getOutputDirectory();

    protected abstract File getSourceOutputDirectory();

    private void executeApt() throws MojoExecutionException {
        List<File> sourceFiles = this.getSourceFiles(this.getSourceScanner(), "sources");
        if (this.getLog().isInfoEnabled()) {
            int count = sourceFiles.size();
            this.getLog().info((CharSequence)("Processing " + count + " source file" + (count == 1 ? "" : "s")));
        }
        List<String> args = this.createArgs(sourceFiles);
        boolean success = this.fork ? AptUtils.invokeForked(this.getLog(), this.workingDirectory, this.executable, this.meminitial, this.maxmem, args) : AptUtils.invoke(this.getLog(), args);
        if (!success) {
            throw new MojoExecutionException("Apt failed");
        }
    }

    private List<String> createArgs(List<File> sourceFiles) throws MojoExecutionException {
        List<String> sourcePaths;
        ArrayList<String> args = new ArrayList<String>();
        LinkedHashSet<String> classpathElements = new LinkedHashSet<String>();
        classpathElements.addAll(this.getPluginClasspathElements());
        classpathElements.addAll(this.getClasspathElements());
        if (!classpathElements.isEmpty()) {
            args.add("-classpath");
            args.add(AbstractAptMojo.toPath(classpathElements));
        }
        if (!(sourcePaths = this.getSourcePaths()).isEmpty()) {
            args.add("-sourcepath");
            args.add(AbstractAptMojo.toPath(sourcePaths));
        }
        args.add("-d");
        args.add(this.getOutputDirectory().getAbsolutePath());
        if (!this.showWarnings) {
            args.add("-nowarn");
        }
        if (this.encoding != null) {
            args.add("-encoding");
            args.add(this.encoding);
        }
        if (this.verbose) {
            args.add("-verbose");
        }
        args.add("-s");
        args.add(this.getSourceOutputDirectory().getAbsolutePath());
        args.add("-nocompile");
        if (this.options != null) {
            for (String option : this.options) {
                args.add("-A" + option.trim());
            }
        }
        if (StringUtils.isNotEmpty((String)this.factory)) {
            args.add("-factory");
            args.add(this.factory);
        }
        for (File file : sourceFiles) {
            args.add(file.getAbsolutePath());
        }
        return args;
    }

    private static String toPath(Collection<String> paths) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iterator = paths.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(File.pathSeparator);
        }
        return buffer.toString();
    }

    private List<String> getPluginClasspathElements() throws MojoExecutionException {
        try {
            return MavenProjectUtils.getClasspathElements(this.project, this.pluginArtifacts);
        }
        catch (DependencyResolutionRequiredException exception) {
            throw new MojoExecutionException("Cannot get plugin classpath elements", (Exception)((Object)exception));
        }
    }

    private List<String> getSourcePaths() {
        ArrayList<String> sourcePaths = new ArrayList<String>();
        sourcePaths.addAll(this.getCompileSourceRoots());
        if (this.additionalSourceRoots != null) {
            sourcePaths.addAll(this.additionalSourceRoots);
        }
        return sourcePaths;
    }

    private List<File> getSourceFiles(SourceInclusionScanner scanner, String name) throws MojoExecutionException {
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (String path : this.getSourcePaths()) {
            File sourceDir = new File(path);
            sourceFiles.addAll(this.getSourceFiles(scanner, name, sourceDir));
        }
        return sourceFiles;
    }

    private Set<File> getSourceFiles(SourceInclusionScanner scanner, String name, File sourceDir) throws MojoExecutionException {
        Set<File> sources;
        if (sourceDir.isDirectory()) {
            try {
                Set rawSources = scanner.getIncludedSources(sourceDir, this.getOutputDirectory());
                sources = CollectionUtils.genericSet(rawSources, File.class);
            }
            catch (InclusionScanException exception) {
                throw new MojoExecutionException("Error scanning source directory: " + sourceDir, (Exception)((Object)exception));
            }
        } else {
            sources = Collections.emptySet();
        }
        if (this.getLog().isDebugEnabled()) {
            if (sources.isEmpty()) {
                this.getLog().debug((CharSequence)("No " + name + " found in " + sourceDir));
            } else {
                this.getLog().debug((CharSequence)(StringUtils.capitalizeFirstLetter((String)name) + " found in " + sourceDir + ":"));
                LogUtils.log(this.getLog(), 0, sources, (CharSequence)"  ");
            }
        }
        return sources;
    }

    private SourceInclusionScanner getStaleScanner() {
        StaleSourceScanner scanner;
        if (this.force) {
            if (!CollectionUtils.isEmpty(this.outputFiles) || !CollectionUtils.isEmpty(this.outputFileEndings)) {
                this.getLog().warn((CharSequence)"Not using staleness checking - ignoring outputFiles and outputFileEndings");
            }
            this.getLog().debug((CharSequence)"Processing all source files");
            scanner = this.createSimpleScanner();
        } else {
            scanner = new StaleSourceScanner((long)this.staleMillis, this.effectiveIncludes, this.effectiveExcludes);
            if (!CollectionUtils.isEmpty(this.outputFiles)) {
                if (!CollectionUtils.isEmpty(this.outputFileEndings)) {
                    this.getLog().warn((CharSequence)"Both outputFiles and outputFileEndings specified - using outputFiles");
                }
                this.getLog().debug((CharSequence)("Computing stale sources against target files " + this.outputFiles));
                for (String file : this.outputFiles) {
                    scanner.addSourceMapping((SourceMapping)new SingleTargetSourceMapping(".java", file));
                }
            } else {
                Set<String> suffixes = CollectionUtils.defaultSet(this.outputFileEndings, Collections.singleton(".java"));
                this.getLog().debug((CharSequence)("Computing stale sources against target file endings " + suffixes));
                scanner.addSourceMapping((SourceMapping)new SuffixMapping(".java", suffixes));
            }
        }
        return scanner;
    }

    private SourceInclusionScanner getSourceScanner() {
        SourceInclusionScanner scanner = this.force || CollectionUtils.isEmpty(this.outputFiles) ? this.getStaleScanner() : this.createSimpleScanner();
        return scanner;
    }

    private SourceInclusionScanner createSimpleScanner() {
        SimpleSourceInclusionScanner scanner = new SimpleSourceInclusionScanner(this.effectiveIncludes, this.effectiveExcludes);
        scanner.addSourceMapping((SourceMapping)new SuffixMapping("", ""));
        return scanner;
    }
}

