/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.introspect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotationMap;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMethod
extends Annotated {
    final Method _method;
    final AnnotationMap _annotations;
    public Class<?>[] _paramTypes;

    public AnnotatedMethod(Method method, AnnotationMap annMap) {
        this._method = method;
        this._annotations = annMap;
    }

    public void addIfNotPresent(Annotation a) {
        this._annotations.addIfNotPresent(a);
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotations.get(acls);
    }

    @Override
    public Class<?> getType() {
        return this.getReturnType();
    }

    public Type[] getGenericParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    public Class<?>[] getParameterTypes() {
        if (this._paramTypes == null) {
            this._paramTypes = this._method.getParameterTypes();
        }
        return this._paramTypes;
    }

    public int getParameterCount() {
        return this.getParameterTypes().length;
    }

    public Type getGenericReturnType() {
        return this._method.getGenericReturnType();
    }

    public Class<?> getReturnType() {
        return this._method.getReturnType();
    }

    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName() + "(" + this.getParameterCount() + " params)";
    }

    public int getAnnotationCount() {
        return this._annotations.size();
    }

    public void fixAccess() {
        ClassUtil.checkAndFixAccess(this._method);
    }

    public String toString() {
        return "[method " + this.getName() + ", annotations: " + this._annotations + "]";
    }
}

