/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractDigitsFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSUnsignedByte
extends AbstractDigitsFacet {
    public static final String NAME = "unsignedByte";
    public static final short TYPE = 48;
    public static final String MIN_VALUE = "0";
    public static final String MAX_VALUE = "255";
    private final boolean _asWrapper;
    private final JType _jType;

    public XSUnsignedByte() {
        this(false);
    }

    public XSUnsignedByte(boolean asWrapper) {
        this._asWrapper = asWrapper;
        this._jType = asWrapper ? new JClass("java.lang.Short") : JType.SHORT;
        this.setMinInclusive(MIN_VALUE);
        this.setMaxInclusive(MAX_VALUE);
    }

    public String getName() {
        return NAME;
    }

    public short getType() {
        return 48;
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isDateTime() {
        return false;
    }

    public JType getJType() {
        return this._jType;
    }

    public String newInstanceCode() {
        return "new java.lang.Short((short) 0);";
    }

    public String createDefaultValueWithString(String variableName) {
        if (this._asWrapper) {
            return "new java.lang.Short(" + variableName + ")";
        }
        return "new java.lang.Short(" + variableName + ").shortValue()";
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return variableName;
        }
        return "new java.lang.Short(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return "((java.lang.Short) " + variableName + ")";
        }
        return "((java.lang.Short) " + variableName + ").shortValue()";
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.ShortValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.ShortValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed((short) " + fixedValue + ");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("typeValidator.setMinExclusive((short) " + this.getMinExclusive() + ");");
        } else if (this.getMinInclusive() != null) {
            jsc.add("typeValidator.setMinInclusive((short) " + this.getMinInclusive() + ");");
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("typeValidator.setMaxExclusive((short) " + this.getMaxExclusive() + ");");
        } else if (this.getMaxInclusive() != null) {
            jsc.add("typeValidator.setMaxInclusive((short) " + this.getMaxInclusive() + ");");
        }
        this.codeDigitsFacet(jsc, "typeValidator");
    }
}

