/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JField;
import org.exolab.javasource.JInnerClass;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JNaming;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public abstract class AbstractJClass
extends JStructure {
    private JSourceCode _staticInitializer = new JSourceCode();
    private JNamedMap _fields = new JNamedMap();
    private Vector _constructors = new Vector();
    private Vector _methods = new Vector();
    private Vector _innerClasses = null;

    protected AbstractJClass(String name) {
        super(name);
        this.getJDocComment().appendComment("Class " + this.getLocalName() + ".");
    }

    public final JSourceCode getStaticInitializationCode() {
        return this._staticInitializer;
    }

    public final JField getField(String name) {
        return (JField)this._fields.get(name);
    }

    public final JField[] getFields() {
        int size = this._fields.size();
        JField[] farray = new JField[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JField)this._fields.get(i);
        }
        return farray;
    }

    public final void addField(JField jField) {
        if (jField == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String name = jField.getName();
        if (this._fields.get(name) != null) {
            String nameToCompare = name.startsWith("_") ? name.substring(1) : name;
            if (JNaming.isReservedByCastor(nameToCompare = nameToCompare.substring(0, 1).toUpperCase() + nameToCompare.substring(1))) {
                String warn = "'" + nameToCompare + "' might conflict with a field name used" + " by Castor.  If you get a complaint\nabout a duplicate name, you will" + " need to use a mapping file or change the name\nof the conflicting" + " schema element.";
                System.out.println(warn);
            }
            String err = "Duplicate name found as a class member: " + name;
            throw new IllegalArgumentException(err);
        }
        this._fields.put(name, jField);
    }

    public final JField removeField(String name) {
        if (name == null) {
            return null;
        }
        JField field = (JField)this._fields.remove(name);
        return field;
    }

    public final boolean removeField(JField jField) {
        if (jField == null) {
            return false;
        }
        Object field = this._fields.get(jField.getName());
        if (field == jField) {
            this._fields.remove(jField.getName());
            return true;
        }
        return false;
    }

    public final JConstructor createConstructor() {
        return this.createConstructor(null);
    }

    public final JConstructor createConstructor(JParameter[] params) {
        JConstructor cons = new JConstructor(this);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                cons.addParameter(params[i]);
            }
        }
        this.addConstructor(cons);
        return cons;
    }

    public final JConstructor getConstructor(int index) {
        return (JConstructor)this._constructors.elementAt(index);
    }

    public final JConstructor[] getConstructors() {
        int size = this._constructors.size();
        JConstructor[] jcArray = new JConstructor[size];
        for (int i = 0; i < this._constructors.size(); ++i) {
            jcArray[i] = (JConstructor)this._constructors.elementAt(i);
        }
        return jcArray;
    }

    public final void addConstructor(JConstructor constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructors cannot be null");
        }
        if (constructor.getDeclaringClass() == this) {
            if (!this._constructors.contains(constructor)) {
                this._constructors.addElement(constructor);
            }
        } else {
            String err = "The given JConstructor was not created by this JClass";
            throw new IllegalArgumentException(err);
        }
    }

    public final boolean removeConstructor(JConstructor constructor) {
        return this._constructors.removeElement(constructor);
    }

    public final JMethod[] getMethods() {
        int size = this._methods.size();
        JMethod[] marray = new JMethod[size];
        for (int i = 0; i < this._methods.size(); ++i) {
            marray[i] = (JMethod)this._methods.elementAt(i);
        }
        return marray;
    }

    public final JMethod getMethod(String name, int startIndex) {
        for (int i = startIndex; i < this._methods.size(); ++i) {
            JMethod jMethod = (JMethod)this._methods.elementAt(i);
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public final JMethod getMethod(int index) {
        return (JMethod)this._methods.elementAt(index);
    }

    public final void addMethod(JMethod jMethod, boolean importReturnType) {
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean added = false;
        JModifiers modifiers = jMethod.getModifiers();
        if (modifiers.isAbstract()) {
            this.getModifiers().setAbstract(true);
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod tmp = (JMethod)this._methods.elementAt(i);
            if (tmp.getModifiers().isPrivate() && !modifiers.isPrivate()) {
                this._methods.insertElementAt(jMethod, i);
                added = true;
                break;
            }
            if (jMethod.getName().compareTo(tmp.getName()) >= 0) continue;
            this._methods.insertElementAt(jMethod, i);
            added = true;
            break;
        }
        if (!added) {
            this._methods.addElement(jMethod);
        }
    }

    public final void addMethod(JMethod jMethod) {
        this.addMethod(jMethod, true);
    }

    public final void addMethods(JMethod[] jMethods) {
        for (int i = 0; i < jMethods.length; ++i) {
            this.addMethod(jMethods[i]);
        }
    }

    public final boolean removeMethod(JMethod method) {
        return this._methods.removeElement(method);
    }

    public final JClass createInnerClass(String localname) {
        if (localname == null) {
            String err = "argument 'localname' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (localname.indexOf(46) >= 0) {
            String err = "The name of an inner-class must not contain a package name.";
            throw new IllegalArgumentException(err);
        }
        String classname = this.getPackageName();
        classname = classname != null ? classname + "." + localname : localname;
        JInnerClass innerClass = new JInnerClass(classname);
        if (this._innerClasses == null) {
            this._innerClasses = new Vector();
        }
        this._innerClasses.addElement(innerClass);
        return innerClass;
    }

    public final JClass[] getInnerClasses() {
        if (this._innerClasses != null) {
            int size = this._innerClasses.size();
            Object[] carray = new JClass[size];
            this._innerClasses.copyInto(carray);
            return carray;
        }
        return new JClass[0];
    }

    public final boolean removeInnerClass(JClass jClass) {
        if (this._innerClasses != null) {
            return this._innerClasses.removeElement(jClass);
        }
        return false;
    }

    public final void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public abstract void print(JSourceWriter var1, boolean var2);

    protected final void printClassHeaders(JSourceWriter jsw) {
        int i;
        this.printHeader(jsw);
        this.printPackageDeclaration(jsw);
        Vector<String> removeImports = null;
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            removeImports = new Vector<String>();
            for (i = 0; i < this._innerClasses.size(); ++i) {
                JClass iClass = (JClass)this._innerClasses.elementAt(i);
                Enumeration enumeration = iClass.getImports();
                while (enumeration.hasMoreElements()) {
                    String classname = (String)enumeration.nextElement();
                    int paramTypeIndex = classname.indexOf("<Object>");
                    if (paramTypeIndex != -1) {
                        classname = classname.substring(0, paramTypeIndex - 1);
                    }
                    if (this.hasImport(classname)) continue;
                    this.addImport(classname);
                    removeImports.addElement(classname);
                }
            }
        }
        this.printImportDeclarations(jsw);
        if (removeImports != null) {
            for (i = 0; i < removeImports.size(); ++i) {
                this.removeImport((String)removeImports.elementAt(i));
            }
        }
    }

    protected final void printMemberVariables(JSourceWriter jsw) {
        if (this._fields.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //--------------------------/");
            jsw.writeln(" //- Class/Member Variables -/");
            jsw.writeln("//--------------------------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._fields.size(); ++i) {
            JField jField = (JField)this._fields.get(i);
            JDocComment comment = jField.getComment();
            if (comment != null) {
                comment.print(jsw);
            }
            jField.printAnnotations(jsw);
            jsw.write(jField.getModifiers().toString());
            jsw.write(32);
            JType type = jField.getType();
            String typeName = type.toString();
            if (typeName.equals(this.toString())) {
                typeName = type.getLocalName();
            }
            jsw.write(typeName);
            jsw.write(32);
            jsw.write(jField.getName());
            String init = jField.getInitString();
            if (init != null && !jField.isDateTime()) {
                jsw.write(" = ");
                jsw.write(init);
            }
            jsw.writeln(';');
            jsw.writeln();
        }
    }

    protected final void printStaticInitializers(JSourceWriter jsw) {
        if (!this._staticInitializer.isEmpty()) {
            jsw.writeln();
            jsw.writeln("static {");
            jsw.writeln(this._staticInitializer.toString());
            jsw.writeln("};");
            jsw.writeln();
        }
    }

    protected final void printConstructors(JSourceWriter jsw) {
        if (this._constructors.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //----------------/");
            jsw.writeln(" //- Constructors -/");
            jsw.writeln("//----------------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._constructors.size(); ++i) {
            JConstructor jConstructor = (JConstructor)this._constructors.elementAt(i);
            jConstructor.print(jsw);
            jsw.writeln();
        }
    }

    protected final void printMethods(JSourceWriter jsw) {
        if (this._methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod jMethod = (JMethod)this._methods.elementAt(i);
            jMethod.print(jsw);
            jsw.writeln();
        }
    }

    protected final void printInnerClasses(JSourceWriter jsw) {
        if (this._innerClasses != null && this._innerClasses.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------------/");
            jsw.writeln(" //- Inner Classes -/");
            jsw.writeln("//-----------------/");
            jsw.writeln();
            for (int i = 0; i < this._innerClasses.size(); ++i) {
                JClass jClass = (JClass)this._innerClasses.elementAt(i);
                jClass.print(jsw, true);
                jsw.writeln();
            }
        }
    }
}

