/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.factory;

import org.exolab.castor.builder.BuilderConfiguration;
import org.exolab.castor.builder.GroupNaming;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.builder.factory.FieldInfoFactory;

public class BaseFactory {
    private final BuilderConfiguration _config;
    private final FieldInfoFactory _infoFactory;
    private GroupNaming _groupNaming = null;
    private SourceGenerator _sourceGenerator;

    public BaseFactory(BuilderConfiguration config, FieldInfoFactory infoFactory, GroupNaming groupNaming, SourceGenerator sourceGenerator) {
        if (config == null) {
            String err = "The 'BuilderConfiguration' argument must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._config = config;
        this._infoFactory = infoFactory == null ? new FieldInfoFactory() : infoFactory;
        this._groupNaming = groupNaming;
        this._sourceGenerator = sourceGenerator;
    }

    protected final BuilderConfiguration getConfig() {
        return this._config;
    }

    protected final FieldInfoFactory getInfoFactory() {
        return this._infoFactory;
    }

    protected final String normalize(String value) {
        if (value == null) {
            return null;
        }
        char[] chars = value.toCharArray();
        char[] newChars = new char[chars.length * 2];
        int count = 0;
        int i = 0;
        boolean skip = false;
        while (i < chars.length) {
            char ch;
            if ((ch = chars[i++]) == ' ' || ch == '\t') {
                if (!skip && count != 0) {
                    newChars[count++] = 32;
                }
                skip = true;
                continue;
            }
            if (ch == '*') {
                if (i >= chars.length || chars[i] != '/') continue;
                newChars[count++] = ch;
                newChars[count++] = 92;
                continue;
            }
            if (count == 0 && (ch == '\r' || ch == '\n')) continue;
            newChars[count++] = ch;
            skip = false;
        }
        return new String(newChars, 0, count);
    }

    public final GroupNaming getGroupNaming() {
        return this._groupNaming;
    }

    public final void setGroupNaming(GroupNaming groupNaming) {
        this._groupNaming = groupNaming;
    }

    protected SourceGenerator getSourceGenerator() {
        return this._sourceGenerator;
    }
}

