/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.impl.borda;

import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.Optional;
import org.chorem.pollen.votecounting.api.AbstractVoteCountingMinMaxChoice;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.chorem.pollen.votecounting.api.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.chorem.pollen.votecounting.api.model.VoteForChoice;
import org.chorem.pollen.votecounting.impl.borda.BordaConfig;
import org.chorem.pollen.votecounting.impl.borda.BordaVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class BordaVoteCounting
extends AbstractVoteCountingMinMaxChoice {
    public BordaVoteCounting() {
        super(VoteCountings.Borda);
    }

    public BordaVoteCountingStrategy newStrategy() {
        return new BordaVoteCountingStrategy();
    }

    @Override
    public BordaConfig createConfig() {
        return new BordaConfig();
    }

    @Override
    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    @Override
    public Optional<Double> getMinimumValue() {
        return Optional.of(1.0);
    }

    @Override
    public Multimap<String, String> validateVoteForChoice(VoteForChoice voteForChoice, VoteCountingConfig config, Locale locale) {
        Multimap<String, String> errorMap = super.validateVoteForChoice(voteForChoice, config, locale);
        Double voteValue = voteForChoice.getVoteValue();
        if (voteValue != null && voteValue < 0.0) {
            errorMap.put((Object)"voteValue", (Object)I18n.l((Locale)locale, (String)"pollen.voteCountingType.borda.voteValue.error.positive", (Object[])new Object[]{voteValue}));
        }
        return errorMap;
    }
}

