/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.votecounting.business;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Méthode de dépouillement standard.
 *
 * @version $Id: StandardMethod.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class StandardMethod implements Method {

    @Override
    public void executeMethod(List<Choice> choices, boolean byGroup) {
        calculateGroups(choices);
        if (byGroup) {
            calculateChoicesByGroup(choices);
        }
    }

    // Pre traitement de la valeur des groupes + totalChoice (tout le monde)
    public void calculateGroups(List<Choice> choices) {
        for (Choice choice : choices) {
            double totalChoice = 0.;
            for (Group group : choice.getGroups()) {
                this.getValueForGroup(group);
                totalChoice += group.getValue();
            }
            choice.setValue(totalChoice);
        }
    }

    public void getValueForGroup(Group group) {
        double total = 0.;
        for (Vote vote : group.getVotes()) {
            total += vote.getValue() * vote.getWeight();
        }
        group.setValue(total);
    }

    // Calcul avec prise en compte des groupes
    public void calculateChoicesByGroup(List<Choice> choices) {
        Map<String, List<String>> mapGroupsChoosenChoices = this
                .getChoosenChoicesByGroup(choices);

        for (Choice choice : choices) {
            double totalChoice = 0.;
            for (String idGroup : mapGroupsChoosenChoices.keySet()) {
                totalChoice += this.getValueForChoiceByGroup(choice, idGroup,
                        mapGroupsChoosenChoices.get(idGroup));
            }
            choice.setValue(totalChoice);
        }
    }

    // Récupération du choix de chaque groupe (plusieurs choix si égalité)
    public Map<String, List<String>> getChoosenChoicesByGroup(
            List<Choice> choices) {
        Map<String, List<String>> mapGroupsChoosenChoices = new HashMap<String, List<String>>();
        for (Group group : choices.get(0).getGroups()) {
            double maxValue = 0.;
            List<String> choosenChoicesId = new ArrayList<String>();
            for (Choice choice : choices) {
                Group curr = choice.getGroup(group.getIdGroup());
                if (curr.getValue() > maxValue) {
                    maxValue = curr.getValue();
                    choosenChoicesId.clear();
                }
                if (curr.getValue() != 0 && maxValue == curr.getValue()) {
                    choosenChoicesId.add(choice.getIdChoice());
                }
            }
            mapGroupsChoosenChoices.put(group.getIdGroup(), choosenChoicesId);
        }
        return mapGroupsChoosenChoices;
    }

    public double getValueForChoiceByGroup(Choice choice, String idGroup,
            List<String> choicesId) {
        for (String idChoice : choicesId) {
            if (choice.getIdChoice().equals(idChoice)) {
                return 1 * choice.getGroup(idGroup).getWeight(); // 1 a remplacer suivant l'algo
            }
        }
        return 0;
    }
}