/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.strategy;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.ChoiceToVoteRenderType;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.chorem.pollen.votecounting.model.Voter;
import org.chorem.pollen.votecounting.strategy.AbstractVoteCountingStrategy;
import org.nuiton.i18n.I18n;

public class BordaStrategy
extends AbstractVoteCountingStrategy {
    public static final int ID = 4;
    private static final Log log = LogFactory.getLog(BordaStrategy.class);

    public int getId() {
        return 4;
    }

    public String getI18nName() {
        return I18n.n_((String)"pollen.voteCountingType.borda", (Object[])new Object[0]);
    }

    public String getI18nHelp() {
        return I18n.n_((String)"pollen.voteCountingType.borda.help", (Object[])new Object[0]);
    }

    public String getTotalVoteValueNotValidMessage(Locale locale) {
        return null;
    }

    public String getVoteValueNotValidMessage(Locale locale) {
        return I18n.l_((Locale)locale, (String)"pollen.error.vote.invalidBordaVoteValue", (Object[])new Object[0]);
    }

    public String getDisplayVoteValue(Integer voteValue) {
        return voteValue == null ? "" : String.valueOf(voteValue);
    }

    public ChoiceToVoteRenderType getVoteValueEditorType() {
        return ChoiceToVoteRenderType.TEXTFIELD;
    }

    public boolean isChoiceInVote(Integer voteValue) {
        return voteValue != null && voteValue > 0 && voteValue < 100;
    }

    public boolean isVoteValueNull(Integer voteValue) {
        return voteValue == null;
    }

    public boolean isDisplayResultsByChoice() {
        return false;
    }

    public boolean isVoteValueValid(Integer voteValue) {
        return voteValue != null && voteValue > 0;
    }

    public boolean isTotalVoteValueValid(int totalValues) {
        return true;
    }

    public VoteCountingResult votecount(Set<Voter> voters) {
        SortedMap resultByChoice = this.votersToResult(voters);
        int nbChoices = resultByChoice.keySet().size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Nb choices: " + nbChoices));
        }
        Map voterSortedChoices = this.buildVoterSortedChoices(voters);
        for (Map.Entry entry : voterSortedChoices.entrySet()) {
            Voter voter = (Voter)entry.getKey();
            double weight = voter.getWeight();
            double choiceWeight = (double)nbChoices * weight;
            for (Set sortedChoiceId : (List)entry.getValue()) {
                for (String choiceId : sortedChoiceId) {
                    ((ChoiceScore)resultByChoice.get(choiceId)).addScoreValue(choiceWeight);
                }
                choiceWeight -= weight;
            }
        }
        VoteCountingResult result = this.resultToList(resultByChoice);
        return result;
    }
}

