/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.util.UrlHelper;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceType;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.services.impl.PollVoteCountingService;
import org.chorem.pollen.ui.PollenUIUtils;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollUriAware;
import org.chorem.pollen.ui.actions.PollenActionSupport;
import org.chorem.pollen.ui.actions.PollenUserSecurityAware;
import org.chorem.pollen.ui.converters.DateConverter;
import org.chorem.pollen.votecounting.VoteCounting;
import org.chorem.pollen.votecounting.model.ChoiceScore;
import org.chorem.pollen.votecounting.model.GroupVoteCountingResult;
import org.chorem.pollen.votecounting.model.VoteCountingResult;
import org.nuiton.topia.persistence.TopiaId;

public class ResultForPoll
extends PollenActionSupport
implements PollenUserSecurityAware,
PollUriAware {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ResultForPoll.class);
    private boolean feedFileExisting;
    private Poll poll;
    private VoteCountingResult pollResult;
    private GroupVoteCountingResult groupResult;
    private Map<String, Choice> choicesById;
    private Map<String, VotingList> groupsById;
    @Inject(required=true)
    private transient UrlHelper urlHelper;
    private Boolean byGroup;

    public ResultForPoll() {
        super(PageSkin.RESULT);
    }

    public Poll getPoll() {
        return this.poll;
    }

    public boolean isCreatorOrAdmin() {
        return this.getUserSecurityContext().isCreator() || this.isUserAdmin();
    }

    public boolean isFeedFileExisting() {
        return this.feedFileExisting;
    }

    public Boolean getByGroup() {
        return this.byGroup;
    }

    public void setByGroup(Boolean byGroup) {
        this.byGroup = byGroup;
    }

    public String getVoteCountingTypeName() {
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        String result = voteCounting.getName(this.getLocale());
        return result;
    }

    public String getVoteCountingTypeHelp() {
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        String result = voteCounting.getShortHelp(this.getLocale());
        return result;
    }

    public String getSummaryUrl() {
        PollUrl url = this.getPollUrlService().getPollSummaryUrl(this.poll);
        url.getPollUri().setAccountId(this.getUserSecurityContext().getAccountId());
        return url.getUrl();
    }

    public String getResultUrl(boolean byGroup) {
        PollUrl url = this.getPollUrlService().getPollResultUrl(this.poll);
        url.getPollUri().setAccountId(this.getUserSecurityContext().getAccountId());
        String result = url.getUrl();
        if (!byGroup) {
            result = result + "?byGroup=false";
        }
        return result;
    }

    public String getVoteUrl() {
        PollUrl url = this.getPollUrlService().getPollVoteUrl(this.poll);
        url.getPollUri().setAccountId(this.getUserSecurityContext().getAccountId());
        if (this.poll.isPollFree()) {
            this.getUserSecurityContext().removeAccountIdWhenConnected(url);
        }
        return url.getUrl();
    }

    public String getPollCreatorName() {
        PollAccount creator = this.poll.getCreator();
        String result = creator.getVotingId();
        if (StringUtils.isBlank((CharSequence)result)) {
            result = creator.getEmail();
        }
        if (StringUtils.isBlank((CharSequence)result)) {
            result = this._("pollen.common.undefined", new Object[0]);
        }
        return result;
    }

    public String getPollBeginDate() {
        Date date = this.poll.getBeginDate();
        String result = date == null ? this._("pollen.common.undefined", new Object[0]) : this.getPollService().decorateDate(date);
        return result;
    }

    public String getPollEndDate() {
        Date date = this.poll.getEndDate();
        String result = date == null ? this._("pollen.common.undefined", new Object[0]) : this.getPollService().decorateDate(date);
        return result;
    }

    public Set<String> getGroupIds() {
        return this.groupResult.getGroupIds();
    }

    public GroupVoteCountingResult getGroupResult() {
        return this.groupResult;
    }

    public VoteCountingResult getPollResult() {
        return this.pollResult;
    }

    public Date getResultAsDate(String choiceName) {
        Date date = new Date(Long.valueOf(choiceName));
        return date;
    }

    public String getVoteSizeMessage() {
        String result = PollenUIUtils.getVoteSizeMessage((Poll)this.getPoll(), (Locale)this.getLocale());
        return result;
    }

    public String getVictoryMessage() {
        List topRanking = this.pollResult.getTopRanking();
        String victoryMessage = CollectionUtils.isEmpty((Collection)topRanking) ? "" : (topRanking.size() == 1 ? this._("pollen.common.victory", new Object[0]) : this._("pollen.common.victories", new Object[0]));
        return victoryMessage;
    }

    public String execute() throws Exception {
        this.poll = this.getUserSecurityContext().getPoll();
        if (this.byGroup == null) {
            this.byGroup = this.poll.isPollGroup();
        }
        this.choicesById = Maps.uniqueIndex((Iterable)this.poll.getChoice(), (Function)TopiaId.GET_TOPIA_ID);
        this.feedFileExisting = this.getSecurityService().isCanShowFeed(this.getUserSecurityContext());
        PollVoteCountingService voteCountingService = (PollVoteCountingService)this.getService(PollVoteCountingService.class);
        if (this.poll.isPollGroup() && this.getByGroup().booleanValue()) {
            this.groupsById = Maps.newHashMap();
            for (VotingList votingList : this.poll.getVotingList()) {
                this.groupsById.put(votingList.getTopiaId(), votingList);
            }
            this.groupResult = voteCountingService.getGroupResult(this.poll);
            this.pollResult = this.groupResult.getMainResult();
        } else {
            this.pollResult = voteCountingService.getSimpleResult(this.poll);
        }
        if (this.poll.isRunning(this.serviceContext.getCurrentTime())) {
            this.addFlashWarning(this._("pollen.information.pollRunning", new Object[0]));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("topRanking = " + this.pollResult.getTopRanking()));
        }
        return "success";
    }

    public boolean isTextType() {
        return this.poll.getChoiceType() == ChoiceType.TEXT;
    }

    public boolean isDateType() {
        return this.poll.getChoiceType() == ChoiceType.DATE;
    }

    public boolean isImageType() {
        return this.poll.getChoiceType() == ChoiceType.IMAGE;
    }

    public String getNormalPollResultChartUrl(int width, int height) {
        String title = this.poll.isPollGroup() && this.getByGroup() == false ? this._("pollen.common.pollResult.forPollAsNotGroupPoll", new Object[0]) : this._("pollen.common.pollResult.forPoll", new Object[0]);
        return this.getPollResultChartUrl(this.pollResult, title, width, height);
    }

    public String getGroupPollResultChartUrl(String groupId, int width, int height) {
        VoteCountingResult result = this.groupResult.getGroupResult(groupId);
        String groupName = this.getGroupName(groupId);
        String title = this._("pollen.common.pollResult.forGroup", new Object[]{groupName});
        return this.getPollResultChartUrl(result, title, width, height);
    }

    public String getChoiceName(String id) {
        String result = ((Choice)this.choicesById.get(id)).getName();
        return result;
    }

    public String getGroupName(String id) {
        String result = ((VotingList)this.groupsById.get(id)).getName();
        return result;
    }

    protected String getPollResultChartUrl(VoteCountingResult results, String title, int width, int height) {
        ArrayList choiceValues = Lists.newArrayList();
        for (ChoiceScore result : results.getScores()) {
            String name = this.getChoiceName(result.getChoiceId());
            String value = String.valueOf(result.getScoreValue());
            if (this.isDateType()) {
                Date date = new Date(Long.parseLong(name));
                name = DateConverter.convertToString((Date)date);
            }
            choiceValues.add(name);
            choiceValues.add(value);
        }
        URL applicationUrl = this.getApplicationUrl();
        StringBuilder url = new StringBuilder(applicationUrl.toString());
        url.append("/io/generateChart");
        HashMap params = Maps.newHashMap();
        params.put("width", width);
        params.put("height", height);
        params.put("title", title);
        params.put("values", choiceValues);
        this.urlHelper.buildParametersString((Map)params, url, "&");
        String chartUrl = url.toString();
        return chartUrl;
    }
}

