/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: DisplayPersonToList.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/form/DisplayPersonToList.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.form;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.ui.actions.PollenActionSupport;

/**
 * To display a personToList (use at a poll creation).
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DisplayPersonToList extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    public static final String TOKEN = "personToList";

    /** Logger. */
    private static final Log log = LogFactory.getLog(DisplayPersonToList.class);

    public static String getPersonToListTokenId(String votingListTokenId,
                                                int votingListNumber) {
        return votingListTokenId + "_" + votingListNumber + TOKEN;
    }

    public static String getPersonToListErrorTokenId(String votingListTokenId,
                                                     int votingListNumber,
                                                     int personToListNumber) {
        return getPersonToListErrorTokenId(getPersonToListTokenId(votingListTokenId, votingListNumber), personToListNumber);
    }

    public static String getPersonToListErrorTokenId(String personToListTokenId,
                                                     int personToListNumber) {
        return personToListTokenId + "_error_" + personToListNumber;
    }

    /** Type of the voting list. */
    protected String votingListType;

    /** Number of the vontingList container. */
    protected int votingListNumber;

    /** Number of person to display. */
    protected int personToListNumber;

    protected PersonToList personToList;

    public int getVotingListNumber() {
        return votingListNumber;
    }

    public void setVotingListNumber(int votingListNumber) {
        this.votingListNumber = votingListNumber;
    }

    public String getVotingListType() {
        return votingListType;
    }

    public void setVotingListType(String votingListType) {
        this.votingListType = votingListType;
    }

    public int getPersonToListNumber() {
        return personToListNumber;
    }

    public void setPersonToListNumber(int personToListNumber) {
        this.personToListNumber = personToListNumber;
    }

    public PersonToList getPersonToList() {
        return personToList;
    }

    @Override
    public String execute() throws Exception {

        if (personToList == null) {
            personToList = getPollService().getNewPersonToList(null);
        }
        return SUCCESS;
    }

}
