/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.QuestionDao;
import org.chorem.pollen.services.bean.ChoiceBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.bean.QuestionBean;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.service.ChoiceService;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.nuiton.i18n.I18n;

public class QuestionService
extends PollenServiceSupport {
    public QuestionBean toQuestionBean(Question entity) {
        QuestionBean bean = new QuestionBean();
        Poll pollEntity = entity.getPoll();
        bean.setEntityId(entity.getTopiaId());
        PollenPrincipal creator = pollEntity.getCreator();
        if (creator == null || creator.getPermission() == null) {
            bean.setPermission(null);
        } else {
            bean.setPermission(creator.getPermission().getToken());
        }
        bean.setTitle(entity.getTitle());
        bean.setDescription(entity.getDescription());
        bean.setCreateDate(entity.getTopiaCreateDate());
        bean.setVoteCountingType(entity.getVoteCountingType());
        bean.setVoteCountingConfig(this.getVoteCountingService().getVoteCountingConfig(entity));
        bean.setChoiceAddAllowed(entity.isChoiceAddAllowed());
        bean.setEndChoiceDate(entity.getEndChoiceDate());
        bean.setBeginChoiceDate(entity.getBeginChoiceDate());
        ChoiceService choiceService = this.getChoiceService();
        if (bean.getEntityId() != null) {
            List<ChoiceBean> choices = choiceService.getChoices(entity);
            bean.setChoices(choices);
        }
        if (this.isNotPermitted(PollenPermissions.edit(entity))) {
            bean.setPermission(null);
        } else {
            ReportResumeBean report = this.getReportService().getReport(entity.getTopiaId());
            bean.setReport(report);
        }
        boolean commentIsVisible = entity.isPersisted() && this.isPermitted(PollenPermissions.readComments(entity));
        bean.setCommentIsVisible(commentIsVisible);
        boolean voteIsVisible = entity.isPersisted() && this.isPermitted(PollenPermissions.readVotes(entity));
        bean.setVoteIsVisible(voteIsVisible);
        boolean resultIsVisible = entity.isPersisted() && this.isPermitted(PollenPermissions.readResult(entity));
        bean.setResultIsVisible(resultIsVisible);
        boolean canReadParticipants = entity.isPersisted() && this.isPermitted(PollenPermissions.readParticipants(entity));
        bean.setParticipantsIsVisible(canReadParticipants);
        boolean canVote = entity.isPersisted() && this.isPermitted(PollenPermissions.addVote(entity));
        bean.setCanVote(canVote);
        if (entity.isPersisted()) {
            if (commentIsVisible) {
                long commentCount = this.getCommentService().getQuestionCommentCount(entity);
                bean.setCommentCount(commentCount);
            }
            long voteCount = this.getVoteService().getVoteCount(entity);
            bean.setVoteCount(voteCount);
            long choiceCount = this.getChoiceService().getChoiceCount(entity);
            bean.setChoiceCount(choiceCount);
        }
        return bean;
    }

    public Question toQuestion(QuestionBean bean) {
        Question entity = new Question();
        entity.setTopiaId(bean.getEntityId());
        entity.setTitle(bean.getTitle());
        entity.setDescription(bean.getDescription());
        entity.setVoteCountingType(bean.getVoteCountingType());
        entity.setChoiceAddAllowed(bean.isChoiceAddAllowed());
        entity.setEndChoiceDate(bean.getEndChoiceDate());
        entity.setBeginChoiceDate(bean.getBeginChoiceDate());
        entity.setQuestionOrder(bean.getQuestionOrder());
        return entity;
    }

    public List<Question> getQuestions(Poll poll) {
        this.checkIsConnectedRequired();
        this.checkNotNull(poll);
        return this.getQuestionDao().forPollEquals(poll).findAll();
    }

    public List<QuestionBean> getQuestions(String pollId) {
        this.checkNotNull(pollId);
        Poll poll = this.getPollService().getPoll0(pollId);
        return this.getQuestionBeans(poll);
    }

    public List<QuestionBean> getQuestionBeans(Poll poll) {
        this.checkIsConnectedRequired();
        List questions = this.getQuestionDao().findAllByPollOrdered(poll);
        return questions.stream().map(this::toQuestionBean).toList();
    }

    protected Question getQuestion(Poll poll, String questionId) {
        Question result = (Question)this.getQuestionDao().forTopiaIdEquals(questionId).findUnique();
        if (!poll.equals((Object)result.getPoll())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)result, (PollenEntity)poll);
        }
        return result;
    }

    protected Question getQuestion0(String questionId) {
        return (Question)this.getQuestionDao().forTopiaIdEquals(questionId).findUnique();
    }

    protected Question getQuestion0(PollenEntityId<Question> questionId) {
        return (Question)this.getQuestionDao().forTopiaIdEquals(questionId.getEntityId()).findUnique();
    }

    protected Question saveQuestion(Poll poll, QuestionBean question) {
        Question toSave;
        QuestionDao questionDao = this.getQuestionDao();
        boolean questionExists = question.isPersisted();
        if (questionExists) {
            toSave = this.getQuestion(poll, question.getEntityId());
        } else {
            toSave = (Question)questionDao.newInstance();
            toSave.setPoll(poll);
            questionDao.create((PollenEntity)toSave);
        }
        toSave.setChoiceAddAllowed(question.isChoiceAddAllowed());
        if (question.isChoiceAddAllowed()) {
            toSave.setBeginChoiceDate(question.getBeginChoiceDate());
            toSave.setEndChoiceDate(question.getEndChoiceDate());
        }
        toSave.setDescription(question.getDescription());
        toSave.setTitle(question.getTitle());
        toSave.setVoteCountingType(question.getVoteCountingType());
        String configToJson = this.getVoteCountingService().configToJson(question.getVoteCountingConfig());
        toSave.setVoteCountingConfig(configToJson);
        ChoiceService choiceService = this.getChoiceService();
        choiceService.saveChoices(toSave, question.getChoices());
        return toSave;
    }

    protected ErrorMap checkQuestion(List<Question> existingQuestions, QuestionBean question) {
        ErrorMap errors = new ErrorMap();
        boolean questionExists = question.isPersisted();
        HashSet questionNames = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(existingQuestions)) {
            for (Question question1 : existingQuestions) {
                if (questionExists && question1.getTopiaId().equals(question.getEntityId())) continue;
                questionNames.add(question1.getTitle());
            }
        }
        this.checkChoices(errors, question.getChoices());
        return errors;
    }

    protected void checkChoices(ErrorMap errorMap, List<ChoiceBean> choices) {
        boolean choicesNotEmpty = CollectionUtils.isNotEmpty(choices);
        this.check(errorMap, "choice", choicesNotEmpty, I18n.l((Locale)this.getLocale(), (String)"pollen.error.poll.choice.mandatory", (Object[])new Object[0]));
        if (choicesNotEmpty) {
            ArrayList<Choice> existingChoices = new ArrayList<Choice>();
            for (int i = 0; i < choices.size(); ++i) {
                ChoiceBean choice = choices.get(i);
                ErrorMap choiceErrors = this.getChoiceService().checkChoice(existingChoices, choice);
                choiceErrors.copyTo(errorMap, "choice[" + i + "].");
                existingChoices.add(this.getChoiceService().toChoice(choice));
            }
        }
    }
}

