/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.security;

import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.UsersRight;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.CommentVisibility;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.ResultVisibility;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoteVisibility;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.Polls;
import org.chorem.pollen.services.service.security.PollenSecurityContext;

public class PollenPermissionsHelper
extends PollenServiceSupport {
    protected boolean matchPrincipal(PollenPrincipal principal) {
        if (principal == null) {
            return false;
        }
        boolean samePrincipal = principal.equals(this.getSecurityContext().getMainPrincipal().orElse(null));
        PollenUser principalPollenUser = principal.getPollenUser();
        boolean sameUser = principalPollenUser != null && principalPollenUser.equals(this.getSecurityContext().getPollenUser().orElse(null));
        return samePrincipal || sameUser;
    }

    public boolean canAddPoll() {
        UsersRight usersCanCreatePoll = this.getPollenServiceConfig().getUsersCanCreatePoll();
        return UsersRight.ALL_USERS.equals((Object)usersCanCreatePoll) || UsersRight.USERS_CONNECTED.equals((Object)usersCanCreatePoll) && this.isConnected() || UsersRight.USERS_SELECTED.equals((Object)usersCanCreatePoll) && this.isCanCreatePoll();
    }

    protected boolean isConnected() {
        return this.getSecurityContext().isConnected();
    }

    protected boolean isCanCreatePoll() {
        PollenSecurityContext context = this.getSecurityContext();
        return context.isConnected() && context.getPollenUser().orElseThrow().isCanCreatePoll();
    }

    protected boolean isAdmin() {
        return this.getSecurityContext().isAdmin();
    }

    public boolean canRead(Poll poll) {
        return this.isAdmin() || Polls.isPollFree(poll) || this.matchPrincipal(poll.getCreator()) || Polls.isPollRestricted(poll) && this.isInvited(poll) || Polls.isPollRegistered(poll) && this.isRegisteredAndAccept(poll);
    }

    protected boolean isInvited(Poll poll) {
        PollenPrincipal mainPrincipal = this.getSecurityContext().getMainPrincipal().orElse(null);
        return mainPrincipal != null && this.voterListMemberExistsByPollAndMemberCacheable(poll, mainPrincipal) || this.getSecurityContext().isConnected() && this.voterListMemberExistsByPollAndMemberCacheable(poll, this.getSecurityContext().getPollenUser().orElseThrow());
    }

    private boolean voterListMemberExistsByPollAndMemberCacheable(Poll poll, PollenPrincipal mainPrincipal) {
        return this.serviceContext.getRequestScopeCachedValue(String.format("p=%s / pp=%s", poll.getTopiaId(), mainPrincipal.getTopiaId()), () -> this.getVoterListMemberDao().existsByPollAndMember(poll, mainPrincipal));
    }

    private boolean voterListMemberExistsByPollAndMemberCacheable(Poll poll, PollenUser pollenUser) {
        return this.serviceContext.getRequestScopeCachedValue(String.format("p=%s / pu=%s", poll.getTopiaId(), pollenUser.getTopiaId()), () -> this.getVoterListMemberDao().existsByPollAndMember(poll, pollenUser));
    }

    protected boolean isRegisteredAndAccept(Poll poll) {
        String suffixes = poll.getEmailAddressSuffixes();
        return this.getSecurityContext().isConnected() && (StringUtils.isBlank((CharSequence)suffixes) || Stream.of(suffixes.split(";")).anyMatch(this::isConnectedUserAcceptEmailSuffix));
    }

    protected boolean isConnectedUserAcceptEmailSuffix(String suffix) {
        return this.getConnectedUser().getEmailAddresses().stream().filter(PollenUserEmailAddress::isValidated).map(PollenUserEmailAddress::getEmailAddress).anyMatch(email -> email.endsWith(suffix));
    }

    protected boolean hasVoted(Poll poll) {
        List<Question> questions = this.getQuestionService().getQuestions(poll);
        return questions.stream().anyMatch(this::hasVoted);
    }

    protected boolean hasVoted(Question question) {
        PollenPrincipal mainPrincipal = this.getSecurityContext().getMainPrincipal().orElse(null);
        return mainPrincipal != null && this.voteExistsByQuestionAndVoterCacheable(question, mainPrincipal) || this.getSecurityContext().isConnected() && this.voteExistsByQuestionAndVoterCacheable(question, this.getSecurityContext().getPollenUser().orElseThrow());
    }

    private boolean voteExistsByQuestionAndVoterCacheable(Question question, PollenPrincipal mainPrincipal) {
        return this.serviceContext.getRequestScopeCachedValue(String.format("q=%s / pp=%s", question.getTopiaId(), mainPrincipal.getTopiaId()), () -> this.getVoteDao().existsByQuestionAndVoter(question, mainPrincipal));
    }

    private boolean voteExistsByQuestionAndVoterCacheable(Question question, PollenUser pollenUser) {
        return this.serviceContext.getRequestScopeCachedValue(String.format("q=%s / pu=%s", question.getTopiaId(), pollenUser.getTopiaId()), () -> this.getVoteDao().existsByQuestionAndVoter(question, pollenUser));
    }

    protected boolean isVoter(Poll poll) {
        boolean hasVotedToOneQuestion = false;
        List<Question> questions = this.getQuestionService().getQuestions(poll);
        for (Question question : questions) {
            hasVotedToOneQuestion = hasVotedToOneQuestion || this.hasVoted(question);
        }
        return this.isAdmin() || hasVotedToOneQuestion || Polls.isPollRestricted(poll) && this.isInvited(poll);
    }

    protected boolean isVoter(Question question) {
        return this.isAdmin() || this.hasVoted(question) || Polls.isPollRestricted(question.getPoll()) && this.isInvited(question.getPoll());
    }

    protected boolean isCreator(Poll poll) {
        return this.isAdmin() || this.matchPrincipal(poll.getCreator());
    }

    public boolean canReadComments(Poll poll) {
        return this.canRead(poll) && (this.isAdmin() || CommentVisibility.EVERYBODY.equals((Object)poll.getCommentVisibility()) || CommentVisibility.VOTER.equals((Object)poll.getCommentVisibility()) && (this.isVoter(poll) || this.isCreator(poll)) || CommentVisibility.CREATOR.equals((Object)poll.getCommentVisibility()) && this.isCreator(poll));
    }

    public boolean canReadComments(Question question) {
        return this.canRead(question) && (this.isAdmin() || CommentVisibility.EVERYBODY.equals((Object)question.getPoll().getCommentVisibility()) || CommentVisibility.VOTER.equals((Object)question.getPoll().getCommentVisibility()) && (this.isVoter(question) || this.isCreator(question.getPoll())) || CommentVisibility.CREATOR.equals((Object)question.getPoll().getCommentVisibility()) && this.isCreator(question.getPoll()));
    }

    public boolean canReadVotes(Question question) {
        return this.canRead(question) && (VoteVisibility.EVERYBODY.equals((Object)question.getPoll().getVoteVisibility()) || VoteVisibility.VOTER.equals((Object)question.getPoll().getVoteVisibility()) && (this.isVoter(question) || this.isCreator(question.getPoll())) || VoteVisibility.CREATOR.equals((Object)question.getPoll().getVoteVisibility()) && this.isCreator(question.getPoll()));
    }

    public boolean canReadVotes(Poll poll) {
        return this.canRead(poll) && (VoteVisibility.EVERYBODY.equals((Object)poll.getVoteVisibility()) || VoteVisibility.VOTER.equals((Object)poll.getVoteVisibility()) && (this.isVoter(poll) || this.isCreator(poll)) || VoteVisibility.CREATOR.equals((Object)poll.getVoteVisibility()) && this.isCreator(poll));
    }

    public boolean canReadParticipants(Poll poll) {
        return Polls.isPollRestricted(poll) && this.canRead(poll) && (VoteVisibility.ANONYMOUS.equals((Object)poll.getVoteVisibility()) || Polls.isFinished(poll, this.getNow()) || !poll.isContinuousResults());
    }

    public boolean canReadParticipants(Question question) {
        return Polls.isPollRestricted(question.getPoll()) && this.canRead(question) && (VoteVisibility.ANONYMOUS.equals((Object)question.getPoll().getVoteVisibility()) || Polls.isFinished(question.getPoll(), this.getNow()) || !question.getPoll().isContinuousResults());
    }

    public boolean canRead(Vote vote) {
        return this.matchPrincipal(vote.getVoter()) || this.canReadVotes(vote.getQuestion());
    }

    public boolean canRead(Question question) {
        return this.isAdmin() || Polls.isPollFree(question.getPoll()) || this.matchPrincipal(question.getPoll().getCreator()) || Polls.isPollRestricted(question.getPoll()) && this.isInvited(question.getPoll()) || Polls.isPollRegistered(question.getPoll()) && this.isRegisteredAndAccept(question.getPoll());
    }

    public boolean canReadResult(Question question) {
        return (Polls.isFinished(question.getPoll(), this.getNow()) || question.getPoll().isContinuousResults()) && this.canRead(question) && (ResultVisibility.EVERYBODY.equals((Object)question.getPoll().getResultVisibility()) || ResultVisibility.VOTER.equals((Object)question.getPoll().getResultVisibility()) && (this.isVoter(question) || this.isCreator(question.getPoll())) || ResultVisibility.CREATOR.equals((Object)question.getPoll().getResultVisibility()) && this.isCreator(question.getPoll()));
    }

    public boolean canReadResult(Poll poll) {
        return (Polls.isFinished(poll, this.getNow()) || poll.isContinuousResults()) && this.canRead(poll) && (ResultVisibility.EVERYBODY.equals((Object)poll.getResultVisibility()) || ResultVisibility.VOTER.equals((Object)poll.getResultVisibility()) && (this.isVoter(poll) || this.isCreator(poll)) || ResultVisibility.CREATOR.equals((Object)poll.getResultVisibility()) && this.isCreator(poll));
    }

    public boolean canAddChoice(Question question) {
        return !Polls.isFinished(question.getPoll(), this.getNow()) && this.canEdit(question.getPoll()) || Polls.isAddChoiceRunning(question, this.getNow()) && this.canRead(question);
    }

    public boolean canAddComment(Poll poll) {
        return this.canRead(poll);
    }

    public boolean canAddComment(Question question) {
        return this.canRead(question);
    }

    public boolean canAddVote(Question question) {
        return Polls.isRunning(question.getPoll(), this.getNow()) && (Polls.isPollFree(question.getPoll()) || Polls.isPollRestricted(question.getPoll()) && this.isInvited(question.getPoll()) && !this.hasVoted(question) || Polls.isPollRegistered(question.getPoll()) && this.isRegisteredAndAccept(question.getPoll()) && !this.hasVoted(question));
    }

    public boolean canAddVote(Poll poll) {
        return Polls.isRunning(poll, this.getNow()) && (Polls.isPollFree(poll) || Polls.isPollRestricted(poll) && this.isInvited(poll) && !this.hasVoted(poll) || Polls.isPollRegistered(poll) && this.isRegisteredAndAccept(poll) && !this.hasVoted(poll));
    }

    public boolean canEdit(Poll poll) {
        return this.matchPrincipal(poll.getCreator());
    }

    public boolean canEdit(Question question) {
        return this.matchPrincipal(question.getPoll().getCreator());
    }

    public boolean canEdit(Choice choice) {
        return !Polls.isFinished(choice.getQuestion().getPoll(), this.getNow()) && this.canEdit(choice.getQuestion().getPoll()) || this.matchPrincipal(choice.getCreator());
    }

    public boolean canEdit(Comment comment) {
        return this.matchPrincipal(comment.getAuthor());
    }

    public boolean canEdit(Vote vote) {
        return this.matchPrincipal(vote.getVoter());
    }

    public boolean canDelete(Poll poll) {
        return this.isAdmin() || this.canEdit(poll);
    }

    public boolean canDelete(Choice choice) {
        return this.isAdmin() || this.canEdit(choice);
    }

    public boolean canDelete(Comment comment) {
        return this.isAdmin() || this.canEdit(comment.getPoll()) || this.matchPrincipal(comment.getAuthor());
    }

    public boolean canDelete(Vote vote) {
        return this.isAdmin() || this.canEdit(vote.getQuestion().getPoll()) || this.matchPrincipal(vote.getVoter());
    }

    public boolean canClose(Poll poll) {
        return this.canAddPoll() && this.canEdit(poll);
    }

    public boolean canClone(Poll poll) {
        return this.canAddPoll() && this.canEdit(poll);
    }

    public boolean canExport(Poll poll) {
        return this.canAddPoll() && this.canEdit(poll);
    }
}

