/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import com.google.common.collect.Lists;
import jakarta.mail.internet.InternetAddress;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.service.mail.PollenMail;
import org.nuiton.i18n.I18n;

public class RestrictedPollInvitationEmail
extends PollenMail {
    protected Poll poll;
    protected List<Question> questions;
    protected PollenPrincipal principal;
    private String voteUrl;
    private String token;

    protected RestrictedPollInvitationEmail(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    @Override
    public String getSubject() {
        return I18n.l((Locale)this.locale, (String)"pollen.service.mail.RestrictedPollInvitationEmail.subject", (Object[])new Object[]{this.poll.getTitle()});
    }

    public Poll getPoll() {
        return this.poll;
    }

    public void setPoll(Poll poll) {
        this.poll = poll;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public PollenPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(PollenPrincipal principal) {
        this.principal = principal;
    }

    public void setVoteUrl(String voteUrl) {
        this.voteUrl = voteUrl;
    }

    public String getVoteUrl() {
        return this.voteUrl;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public String getCreationDate() {
        return this.formatDate(this.poll.getTopiaCreateDate());
    }

    public String getBeginDate() {
        return this.formatDate(this.poll.getBeginDate());
    }

    public String getEndDate() {
        return this.formatDate(this.poll.getEndDate());
    }

    public String getBeginChoiceDate() {
        return this.formatDate(this.questions.get(0).getBeginChoiceDate());
    }

    public String getEndChoiceDate() {
        return this.formatDate(this.questions.get(0).getEndChoiceDate());
    }

    @Override
    public List<PollenEntity> getEntitiesKey() {
        return Lists.newArrayList((Object[])new PollenEntity[]{this.poll, this.principal});
    }

    @Override
    public String getFromName() {
        return this.poll.getCreator().getName();
    }

    @Override
    public Collection<InternetAddress> getReplyTo() {
        List<InternetAddress> replyTo = Collections.emptyList();
        PollenPrincipal creator = this.getPoll().getCreator();
        if (StringUtils.isNotBlank((CharSequence)creator.getEmail())) {
            try {
                replyTo = Collections.singletonList(new InternetAddress(creator.getEmail(), creator.getName()));
            }
            catch (UnsupportedEncodingException e) {
                throw new PollenTechnicalException("Error on replyTo adresse", e);
            }
        }
        return replyTo;
    }
}

