/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service.mail;

import com.google.common.collect.Sets;
import jakarta.mail.internet.InternetAddress;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.chorem.pollen.persistence.PollenEntity;

public abstract class PollenMail {
    protected final Locale locale;
    protected final TimeZone timeZone;
    protected Set<String> tos;
    protected Set<String> bccs;
    protected String signing;

    public static String formatDate(Date date, Locale locale, TimeZone timeZone) {
        String result = null;
        if (date != null) {
            DateFormat formatter = DateFormat.getDateTimeInstance(1, 3, locale);
            formatter.setTimeZone(timeZone);
            result = formatter.format(date);
        }
        return result;
    }

    public PollenMail(Locale locale, TimeZone timeZone) {
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Set<String> getTos() {
        if (this.tos == null) {
            this.tos = Sets.newHashSet();
        }
        return this.tos;
    }

    public void addTo(String email) {
        this.getTos().add(email);
    }

    public abstract String getSubject();

    public Set<String> getBccs() {
        if (this.bccs == null) {
            this.bccs = Sets.newHashSet();
        }
        return this.bccs;
    }

    public void addBcc(String email) {
        this.getBccs().add(email);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public boolean isRecipientProvided() {
        return CollectionUtils.isNotEmpty(this.getBccs()) || CollectionUtils.isNotEmpty(this.getTos());
    }

    protected String formatDate(Date date) {
        return PollenMail.formatDate(date, this.locale, this.timeZone);
    }

    public String getSigning() {
        return this.signing;
    }

    public void setSigning(String signing) {
        this.signing = signing;
    }

    public String getFromName() {
        return null;
    }

    public abstract List<PollenEntity> getEntitiesKey();

    public Collection<InternetAddress> getReplyTo() {
        return Collections.emptyList();
    }
}

