/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollType;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenPrincipalDao;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoteDao;
import org.chorem.pollen.persistence.entity.VoteToChoice;
import org.chorem.pollen.persistence.entity.VoteToChoiceDao;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.persistence.entity.VoterListMemberDao;
import org.chorem.pollen.services.bean.PaginationResultBean;
import org.chorem.pollen.services.bean.PollenEntityRef;
import org.chorem.pollen.services.bean.ReportResumeBean;
import org.chorem.pollen.services.bean.VoteBean;
import org.chorem.pollen.services.bean.VoteToChoiceBean;
import org.chorem.pollen.services.config.PollenServicesConfig;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.InvalidEntityLinkException;
import org.chorem.pollen.services.service.InvalidFormException;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.Polls;
import org.chorem.pollen.services.service.security.PollenPermissions;
import org.chorem.pollen.votecounting.api.VoteCounting;
import org.chorem.pollen.votecounting.api.model.VoteCountingConfig;
import org.nuiton.i18n.I18n;
import org.nuiton.util.pagination.PaginationParameter;
import org.nuiton.util.pagination.PaginationResult;

public class VoteService
extends PollenServiceSupport {
    public static final Comparator<VoteToChoice> VOTE_TO_CHOICE_COMPARATOR = Comparator.comparingInt(v -> v.getChoice().getChoiceOrder());

    public VoteBean toVoteBean(Vote entity) {
        VoteBean bean = new VoteBean();
        bean.setEntityId(entity.getTopiaId());
        PollenPrincipal voter = entity.getVoter();
        if (voter == null || voter.getPermission() == null) {
            bean.setPermission(null);
        } else {
            bean.setPermission(voter.getPermission().getToken());
        }
        bean.setAnonymous(entity.isAnonymous());
        if (voter != null) {
            bean.getVoterId().setEntityId(voter.getTopiaId());
            bean.setVoterName(voter.getName());
            if (voter.getPollenUser() != null && voter.getPollenUser().getAvatar() != null) {
                bean.setVoterAvatar(this.getPollenResourceService().getReduceIdByTopiaId(voter.getPollenUser().getAvatar().getTopiaId()));
            }
        }
        bean.setWeight(entity.getWeight());
        entity.getVoteToChoice().stream().sorted(VOTE_TO_CHOICE_COMPARATOR).map(this::toVoteToChoiceBean).forEach(bean::addChoice);
        if (entity.getVoterListMember() != null) {
            bean.setVoterListMembers(entity.getVoterListMember());
        }
        if (this.isNotPermitted(PollenPermissions.edit(entity))) {
            int maxVoters;
            bean.setPermission(null);
            if (entity.isAnonymous()) {
                bean.setVoterName(null);
                bean.setVoterAvatar(null);
            }
            if ((maxVoters = this.getPollService().getMaxVoters(entity.getQuestion().getPoll())) > 0 && this.getVoteDao().getVoteIndex(entity) >= (long)maxVoters) {
                bean.setIgnored(true);
                bean.getChoice().forEach(vc -> vc.setVoteValue(null));
            }
        } else {
            ReportResumeBean report = this.getReportService().getReport(entity.getTopiaId());
            bean.setReport(report);
        }
        return bean;
    }

    public VoteToChoiceBean toVoteToChoiceBean(VoteToChoice entity) {
        VoteToChoiceBean bean = new VoteToChoiceBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setVoteValue(entity.getVoteValue());
        bean.getChoiceId().setEntityId(entity.getChoice().getTopiaId());
        return bean;
    }

    public VoteBean getNewVote(String pollId, String questionId) {
        this.checkIsConnectedRequired();
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        this.checkPermission(PollenPermissions.addVote(question));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        VoteBean voteBean = new VoteBean();
        voteBean.setWeight(1.0);
        PollenPrincipal mainPrincipal = this.getSecurityContext().getMainPrincipal().orElse(null);
        PollenUser connectedUser = this.getConnectedUser();
        if (question.getPoll().getPollType() == PollType.RESTRICTED) {
            ArrayList<VoterListMember> voterListMembers = new ArrayList();
            if (mainPrincipal != null) {
                voterListMembers = this.getVoterListMemberDao().forVoterList_PollIdEqualsAndMember_EmailEquals(question.getPoll().getTopiaId(), mainPrincipal.getEmail()).findAll();
            }
            if (CollectionUtils.isNotEmpty(voterListMembers) && !this.getVoteDao().forQuestionAndVoter(question, mainPrincipal).exists() && mainPrincipal != null) {
                voteBean.setVoterName(mainPrincipal.getName());
                voteBean.setVoterListMembers(voterListMembers);
            } else if (connectedUser != null) {
                voteBean.setVoterName(connectedUser.getName());
            }
        } else if (mainPrincipal != null) {
            voteBean.setVoterName(mainPrincipal.getName());
            List voterListMembers = this.getVoterListMemberDao().forVoterList_PollIdEqualsAndMember_EmailEquals(question.getPoll().getTopiaId(), mainPrincipal.getEmail()).findAll();
            if (voterListMembers != null) {
                voteBean.setVoterListMembers(voterListMembers);
            }
        } else if (connectedUser != null) {
            voteBean.setVoterName(connectedUser.getName());
        }
        return voteBean;
    }

    public PaginationResultBean<VoteBean> getVotes(String pollId, String questionId, PaginationParameter page) {
        this.checkIsConnectedRequired();
        this.checkNotNull(questionId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        PaginationParameter orderedPage = VoteService.orderedPage(page);
        List votes = this.getVoteDao().findAllByQuestionOrdered(question, orderedPage.getOrderClauses()).stream().filter(vote -> this.isPermitted(PollenPermissions.read(vote))).collect(Collectors.toList());
        PaginationResult votePaginationResult = PaginationResult.fromFullList(votes, (PaginationParameter)orderedPage);
        return this.toPaginationListBean(votePaginationResult, this::toVoteBean);
    }

    public VoteBean getVote(String pollId, String questionId, String voteId) {
        this.checkIsConnectedRequired();
        this.checkNotNull(voteId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        Vote vote = this.getVote(question, voteId);
        this.checkPermission(PollenPermissions.read(vote));
        return this.toVoteBean(vote);
    }

    public PollenEntityRef<Vote> addVote(String pollId, String questionId, VoteBean vote) throws InvalidFormException {
        boolean notificationSend;
        this.checkIsConnectedRequired();
        this.checkNotNull(questionId);
        this.checkNotNull(vote);
        this.checkIsNotPersisted(vote);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        this.checkPermission(PollenPermissions.addVote(question));
        ErrorMap errorMap = this.validateVote(question, vote);
        errorMap.failIfNotEmpty();
        Vote result = this.saveVote(question, vote);
        this.commit();
        this.getNotificationService().onVoteAdded(question, result);
        this.getFeedService().onVoteAdded(question, result);
        int maxVoters = this.getPollService().getMaxVoters(question.getPoll());
        if (maxVoters > 0 && this.getVoteCount(question) > (long)maxVoters && (notificationSend = this.getPollDao().setFlagNotificationMaxVoterSend(question.getPoll()))) {
            this.commit();
            this.getNotificationService().onExceedingMaxVoters(question.getPoll(), maxVoters);
        }
        return PollenEntityRef.of(result);
    }

    public VoteBean editVote(String pollId, String questionId, VoteBean vote) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(vote);
        this.checkIsPersisted(vote);
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Vote voteBd = this.getVote(question, vote.getEntityId());
        this.checkPermission(PollenPermissions.edit(voteBd));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        ErrorMap errorMap = this.validateVote(question, vote);
        errorMap.failIfNotEmpty();
        Vote result = this.saveVote(question, vote);
        this.commit();
        this.getNotificationService().onVoteEdited(question, result);
        this.getFeedService().onVoteEdited(question, result);
        return this.toVoteBean(result);
    }

    public void deleteVote(String pollId, String questionId, String voteId) throws InvalidFormException {
        this.checkIsConnectedRequired();
        this.checkNotNull(questionId);
        this.checkNotNull(voteId);
        Poll poll = this.getPollService().getPoll0(pollId);
        Question question = this.getQuestionService().getQuestion0(questionId);
        Vote vote = this.getVote(question, voteId);
        this.checkPermission(PollenPermissions.delete(vote));
        Poll questionPoll = question.getPoll();
        if (!questionPoll.getTopiaId().equals(poll.getTopiaId())) {
            throw new InvalidEntityLinkException("poll", (PollenEntity)question, (PollenEntity)poll);
        }
        ErrorMap errorMap = this.checkPoll(question.getPoll());
        errorMap.failIfNotEmpty();
        this.getVoteDao().delete(vote);
        this.commit();
        this.getNotificationService().onVoteDeleted(question, vote);
        this.getFeedService().onVoteDeleted(question, vote);
    }

    protected ErrorMap checkPoll(Poll poll) {
        ErrorMap errors = new ErrorMap();
        Date now = this.serviceContext.getNow();
        this.check(errors, "poll", Polls.isStarted(poll, now), I18n.l((Locale)this.getLocale(), (String)"pollen.error.vote.poll.notStarted", (Object[])new Object[0]));
        this.check(errors, "poll", !Polls.isFinished(poll, now), I18n.l((Locale)this.getLocale(), (String)"pollen.error.vote.poll.finished", (Object[])new Object[0]));
        return errors;
    }

    protected ErrorMap validateVote(Question question, VoteBean vote) {
        ErrorMap errors = new ErrorMap();
        errors.addAllErrors(this.checkPoll(question.getPoll()));
        boolean voteExists = vote.isPersisted();
        String voterName = vote.getVoterName();
        boolean voteNameNotBlank = this.checkNotBlank(errors, "voter.name", voterName, I18n.l((Locale)this.getLocale(), (String)"pollen.error.vote.voterName.mandatory", (Object[])new Object[0]));
        if (voteNameNotBlank) {
            VoteDao voteDao = this.getVoteDao();
            Optional existingVoteWithVoterName = voteDao.findByQuestionAndVoterName(question, voterName);
            boolean voterNameAvailable = existingVoteWithVoterName.isEmpty() || voteExists && ((Vote)existingVoteWithVoterName.get()).getTopiaId().equals(vote.getEntityId());
            this.check(errors, "voter.name", voterNameAvailable, I18n.l((Locale)this.getLocale(), (String)"pollen.error.vote.voterName.alreadyExist", (Object[])new Object[0]));
        }
        VoteCounting voteCounting = this.getVoteCountingService().getVoteCounting(question);
        VoteCountingConfig config = this.getVoteCountingService().getVoteCountingConfig(question);
        ErrorMap valueErrors = this.getVoteCountingService().validateVote(vote, voteCounting, config);
        valueErrors.copyTo(errors, "vote.");
        return errors;
    }

    protected Vote saveVote(Question question, VoteBean vote) {
        Vote toSave;
        boolean voteExist = vote.isPersisted();
        if (voteExist) {
            toSave = this.getVote(question, vote.getEntityId());
        } else {
            VoteDao voteDao = this.getVoteDao();
            VoterListMemberDao voterListMemberDao = this.getVoterListMemberDao();
            toSave = (Vote)voteDao.newInstance();
            PollenPrincipal mainPrincipal = this.getSecurityContext().getMainPrincipal().orElse(null);
            if (Polls.isPollRestricted(question.getPoll())) {
                voterListMembers = new ArrayList();
                if (mainPrincipal != null) {
                    voterListMembers = voterListMemberDao.forVoterList_PollIdEqualsAndMember_EmailEquals(question.getPoll().getTopiaId(), mainPrincipal.getEmail()).findAll();
                }
                if (CollectionUtils.isNotEmpty(voterListMembers) && !voteDao.forQuestionAndVoter(question, mainPrincipal).exists()) {
                    toSave.setVoterListMember(voterListMembers);
                    toSave.setVoter(mainPrincipal);
                } else {
                    voterListMembers = voterListMemberDao.forVoterList_PollIdEqualsAndMember_PollenUserEquals(question.getPoll().getTopiaId(), this.getConnectedUser()).findAll();
                    toSave.setVoterListMember(voterListMembers);
                    toSave.setVoter(((VoterListMember)voterListMembers.getFirst()).getMember());
                }
            } else {
                if (mainPrincipal != null && !(voterListMembers = voterListMemberDao.findAllByMemberAndPoll(mainPrincipal, question.getPoll())).isEmpty()) {
                    toSave.setVoterListMember(voterListMembers);
                    toSave.setVoter(mainPrincipal);
                }
                if (toSave.getVoter() == null) {
                    toSave.setWeight(1.0);
                    PollenPrincipal author = this.getSecurityService().generatePollenPrincipal();
                    toSave.setVoter(author);
                }
            }
            toSave.setQuestion(question);
            voteDao.create((PollenEntity)toSave);
        }
        toSave.setAnonymous(question.getPoll().isAnonymousVoteAllowed());
        toSave.getVoter().setName(vote.getVoterName());
        PollenUser connectedUser = this.getConnectedUser();
        if (connectedUser != null) {
            toSave.getVoter().setPollenUser(connectedUser);
        }
        if (voteExist) {
            choicesToSave = toSave.getVoteToChoice();
            for (VoteToChoiceBean input : vote.getChoice()) {
                if (input.isPersisted()) {
                    for (VoteToChoice voteToChoice : choicesToSave) {
                        if (!input.getChoiceId().getEntityId().equals(voteToChoice.getChoice().getTopiaId())) continue;
                        voteToChoice.setVoteValue(input.getVoteValue());
                    }
                    continue;
                }
                boolean edited = false;
                for (VoteToChoice voteToChoice : choicesToSave) {
                    if (!input.getChoiceId().getEntityId().equals(voteToChoice.getChoice().getTopiaId())) continue;
                    voteToChoice.setVoteValue(input.getVoteValue());
                    edited = true;
                }
                if (edited) continue;
                choicesToSave.add(this.createVoteToChoice(toSave, input));
            }
        } else {
            choicesToSave = new HashSet<VoteToChoice>();
            for (VoteToChoiceBean input : vote.getChoice()) {
                VoteToChoice voteToChoice = this.createVoteToChoice(toSave, input);
                choicesToSave.add(voteToChoice);
            }
            toSave.setVoteToChoice(choicesToSave);
        }
        return toSave;
    }

    protected Vote getVote(Question question, String voteId) {
        Vote result = (Vote)this.getVoteDao().forTopiaIdEquals(voteId).findUnique();
        if (!question.equals((Object)result.getQuestion())) {
            throw new InvalidEntityLinkException("question", (PollenEntity)result, (PollenEntity)question);
        }
        return result;
    }

    protected VoteToChoice createVoteToChoice(Vote vote, VoteToChoiceBean source) {
        VoteToChoiceDao voteToChoiceDao = this.getVoteToChoiceDao();
        String choiceId = source.getChoiceId().getEntityId();
        Choice choiceLoaded = (Choice)this.getChoiceDao().forTopiaIdEquals(choiceId).findUnique();
        VoteToChoice result = (VoteToChoice)voteToChoiceDao.newInstance();
        result.setChoice(choiceLoaded);
        voteToChoiceDao.create((PollenEntity)result);
        vote.addVoteToChoice(result);
        result.setVoteValue(source.getVoteValue());
        return result;
    }

    public long getVoteCount(Question question) {
        this.checkIsConnectedRequired();
        return this.getVoteDao().forQuestionEquals(question).count();
    }

    public void purgeOldVotes() {
        PollenPrincipalDao principalDao = this.getPollenPrincipalDao();
        VoteDao voteDao = this.getVoteDao();
        PollenServicesConfig applicationConfig = this.getPollenServiceConfig();
        int anonymizeOlderVotesAgeSecond = applicationConfig.getAnonymizeOlderVotesAge();
        Date now = this.serviceContext.getNow();
        Date someTimeAgo = DateUtils.addSeconds((Date)now, (int)(-1 * anonymizeOlderVotesAgeSecond));
        List votesToAnon = voteDao.findAllOldVotes(someTimeAgo);
        ArrayList<PollenPrincipal> principalsToSave = new ArrayList<PollenPrincipal>();
        ArrayList<Vote> votesToSave = new ArrayList<Vote>();
        for (Vote vote : votesToAnon) {
            PollenPrincipal principal = vote.getVoter();
            if (principal.getPollenUser() == null) continue;
            principal.setName("?");
            principalsToSave.add(principal);
            vote.setAnonymous(true);
            votesToSave.add(vote);
        }
        voteDao.updateAll(votesToSave);
        principalDao.updateAll(principalsToSave);
    }
}

