/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.IOUtils;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.bean.resource.AbstractResourceBean;

public class ResourceFileBean
extends AbstractResourceBean {
    protected File file;

    public ResourceFileBean() {
        super(PollenResource.class);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public Blob getResourceBlob() {
        try {
            InputStream stream;
            try {
                stream = new GZIPInputStream(new FileInputStream(this.getFile()));
            }
            catch (ZipException e) {
                stream = new FileInputStream(this.getFile());
            }
            return new SerialBlob(IOUtils.toByteArray((InputStream)stream));
        }
        catch (IOException | SQLException e) {
            throw new PollenTechnicalException(e);
        }
    }
}

