/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.topia.TopiaIdFactory;

public class PollenEntityId<E extends PollenEntity> {
    public static final String TEMPORARY_ID_PREFIX = "TEMP";
    protected final Class<E> entityType;
    protected String entityId;
    protected String reducedId;

    public static <E extends PollenEntity> PollenEntityId<E> newId(Class<E> entityType) {
        return new PollenEntityId<E>(entityType);
    }

    public static <E extends PollenEntity> PollenEntityId<E> ofDecoded(Class<E> entityType, String reducedId) {
        PollenEntityId<E> result = PollenEntityId.newId(entityType);
        result.setReducedId(reducedId);
        result.decode();
        return result;
    }

    public static String encodeStatic(String entityId) {
        return TopiaIdFactory.getRandomPart((String)entityId);
    }

    public static <E extends PollenEntity> String getReduceId(E entity) {
        return PollenEntityId.encodeStatic(entity.getTopiaId());
    }

    public PollenEntityId(Class<E> entityType) {
        this.entityType = entityType;
    }

    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    public boolean isNotEmpty() {
        return StringUtils.isNotEmpty((CharSequence)this.reducedId) || StringUtils.isNotEmpty((CharSequence)this.entityId);
    }

    public String getReducedId() {
        return this.reducedId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setReducedId(String reducedId) {
        this.reducedId = reducedId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public boolean isTemporaryId() {
        return this.reducedId != null && this.reducedId.startsWith(TEMPORARY_ID_PREFIX);
    }

    public void encode() {
        if (this.entityId != null) {
            String id = PollenEntityId.encodeStatic(this.entityId);
            this.setReducedId(id);
        }
    }

    public void decode() {
        if (this.reducedId != null && !this.isTemporaryId()) {
            String id = TopiaIdFactory.newTopiaId(this.entityType, (String)this.reducedId);
            this.setEntityId(id);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PollenEntityId)) {
            return false;
        }
        PollenEntityId that = (PollenEntityId)o;
        return this.entityType.equals(that.entityType) && (this.reducedId != null && this.reducedId.equals(that.reducedId) || this.entityId != null && this.entityId.equals(that.entityId));
    }

    public int hashCode() {
        int result = this.entityType.hashCode();
        result = 31 * result + (this.reducedId == null ? 0 : this.reducedId.hashCode());
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        return result;
    }

    public String toString() {
        return this.reducedId;
    }
}

