/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.PollenConfiguration;
import org.chorem.pollen.PollenTechnicalException;
import org.chorem.pollen.entities.PollenDAOHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.TopiaRuntimeException;

public class PollenTopiaRootContextFactory {
    private static final Log log = LogFactory.getLog(PollenTopiaRootContextFactory.class);

    public TopiaContext newEmbeddedDatabase(File dir, String configPath) {
        TopiaContext rootContext;
        File databaseFile = new File(dir, "db");
        String databaseAbsolutePath = databaseFile.getAbsolutePath();
        Properties properties = new Properties();
        InputStream input = null;
        try {
            input = this.getClass().getResourceAsStream(configPath);
            properties.load(input);
            input.close();
        }
        catch (IOException e) {
            try {
                throw new PollenTechnicalException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        properties.setProperty("hibernate.connection.url", "jdbc:h2:file:" + databaseAbsolutePath + "/pollen");
        properties.setProperty("topia.persistence.classes", PollenDAOHelper.getImplementationClassesAsString());
        try {
            rootContext = TopiaContextFactory.getContext((Properties)properties);
        }
        catch (TopiaNotFoundException e) {
            throw new TopiaRuntimeException((Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will output database in " + databaseAbsolutePath));
        }
        return rootContext;
    }

    public TopiaContext newDatabaseFromConfig(PollenConfiguration config) {
        Properties properties = config.getProperties();
        return this.newDatabaseFromProperties(properties);
    }

    public TopiaContext newDatabaseFromProperties(Properties properties) {
        TopiaContext rootContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Database settings are :");
            HashSet keysToDisplay = Sets.newHashSet((Object[])new String[]{"hibernate.dialect", "hibernate.connection.driver_class", "hibernate.connection.url", "hibernate.connection.username"});
            for (String key : keysToDisplay) {
                log.debug((Object)String.format("%s=%s", key, properties.getProperty(key)));
            }
        }
        String classesKey = "topia.persistence.classes";
        String classesValue = PollenDAOHelper.getImplementationClassesAsString();
        properties.setProperty(classesKey, classesValue);
        try {
            rootContext = TopiaContextFactory.getContext((Properties)properties);
        }
        catch (TopiaNotFoundException e) {
            throw new TopiaRuntimeException((Throwable)e);
        }
        return rootContext;
    }
}

