/*
 * #%L
 * Pollen :: Persistence
 * $Id: PersonListDAOImpl.java 3691 2012-09-14 16:33:06Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.5/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/PersonListDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;

import java.util.List;

public class PersonListDAOImpl<E extends PersonList> extends PersonListDAOAbstract<E> {

    public List<E> findFavoriteLists(UserAccount user,
                                     TopiaPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(pager);

        String hql = createSimpleQuery("e") + " WHERE e.owner = :owner";
        String countHql = "SELECT COUNT(*) " + hql;

        computeAndAddRecordsToPager(countHql, pager, "owner", user);

        List<E> result = findAllByQueryAndPager(hql, pager, "owner", user);
        return result;
    }

    public List<E> findAllFavoriteLists(UserAccount user) throws TopiaException {

        Preconditions.checkNotNull(user);

        String hql = createSimpleQuery("e") + " WHERE e.owner = :owner";

        List<E> result = findAllByQuery(hql, "owner", user);
        return result;
    }

    public boolean isPersonListExist(UserAccount user,
                                     String name) throws TopiaException {

        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(StringUtils.isNotEmpty(name));

        String hql = "SELECT COUNT(*) FROM PersonListImpl WHERE " +
                     "owner = :owner AND name = :name";

        boolean result = existsByQuery(hql, "owner", user, "name", name);
        return result;
    }

}
