/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.PollenFunctions;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollDAOAbstract;
import org.chorem.pollen.business.persistence.UserAccount;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

public class PollDAOImpl<E extends Poll>
extends PollDAOAbstract<E> {
    public List<E> getPolls(TopiaPagerBean pager) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        String countHql = "SELECT COUNT(*) FROM PollImpl";
        this.computeAndAddRecordsToPager(countHql, pager, new Object[0]);
        String hql = "FROM PollImpl";
        List result = this.findAllByQueryAndPager(hql, pager, new Object[0]);
        return result;
    }

    public List<E> findCreatedPolls(TopiaPagerBean pager, UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        String countHql = "SELECT COUNT(*) FROM PollImpl WHERE creator.userAccount = :user";
        this.computeAndAddRecordsToPager(countHql, pager, new Object[]{"user", user});
        String hql = "FROM PollImpl WHERE creator.userAccount = :user";
        List result = this.findAllByQueryAndPager(hql, pager, new Object[]{"user", user});
        return result;
    }

    public List<Pair<Poll, PollAccount>> findInvitedPolls(TopiaPagerBean pager, UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        String hql = "SELECT p, l.pollAccount FROM PollImpl p LEFT JOIN p.votingList v LEFT JOIN v.pollAccountPersonToList l WHERE l.pollAccount.email = :email";
        List<Pair<Poll, PollAccount>> result = this.findAllWithPollAccounts(hql, pager, "email", user.getEmail());
        return result;
    }

    public List<Pair<Poll, PollAccount>> findParticipatedPolls(TopiaPagerBean pager, UserAccount user) throws TopiaException {
        Preconditions.checkNotNull((Object)pager);
        Preconditions.checkNotNull((Object)user);
        String hql = "SELECT p, v.pollAccount FROM VoteImpl v, PollImpl p WHERE v IN ELEMENTS(p.vote) AND v.pollAccount.userAccount = :user";
        List<Pair<Poll, PollAccount>> result = this.findAllWithPollAccounts(hql, pager, "user", user);
        return result;
    }

    public List<E> findRunningPollsWithEndTime(Date currentTime) throws TopiaException {
        String hql = "FROM PollImpl WHERE (endDate IS NOT NULL AND endDate > :currentTime) AND (beginDate IS NULL OR beginDate < :currentTime)";
        List results = this.findAllByQuery(hql, new Object[]{"currentTime", currentTime});
        return results;
    }

    protected List<Pair<Poll, PollAccount>> findAllWithPollAccounts(String hql, TopiaPagerBean pager, Object ... params) throws TopiaException {
        List queryResults = this.findAllByQuery(Object[].class, hql, params);
        LinkedHashMap mapResult = Maps.newLinkedHashMap();
        for (Object[] row : queryResults) {
            Poll poll = (Poll)row[0];
            PollAccount pollAccount = (PollAccount)row[1];
            mapResult.put(poll, pollAccount);
        }
        long records = mapResult.size();
        pager.setRecords(records);
        PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)pager);
        LinkedList entries = Lists.newLinkedList(mapResult.entrySet());
        List result = Lists.transform(PollDAOImpl.getPageFromList(entries, pager), PollenFunctions.MAP_ENTRY_TO_PAIR_FUNCTION);
        return result;
    }

    public static <E> List<E> getPageFromList(List<E> elements, TopiaPagerBean pager) {
        PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)pager);
        List subList = PagerBeanUtil.getPage(elements, (int)pager.getPageIndex(), (int)pager.getPageSize());
        ArrayList result = Lists.newArrayList((Iterable)subList);
        return result;
    }
}

