package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class UserAccountAbstract extends TopiaEntityAbstract implements UserAccount {

    /**
     * Nom de l'attribut en BD : login
     */
    protected String login;

    /**
     * Nom de l'attribut en BD : password
     */
    protected String password;

    /**
     * Nom de l'attribut en BD : firstName
     */
    protected String firstName;

    /**
     * Nom de l'attribut en BD : lastName
     */
    protected String lastName;

    /**
     * Nom de l'attribut en BD : administrator
     */
    protected boolean administrator;

    /**
     * Nom de l'attribut en BD : language
     */
    protected String language;

    /**
     * Nom de l'attribut en BD : email
     */
    protected String email;

    /**
     * Nom de l'attribut en BD : favoriteList
     */
    protected List<PersonList> favoriteList;

    /**
     * Nom de l'attribut en BD : pollAccount
     */
    protected List<PollAccount> pollAccount;

    private static final long serialVersionUID = 3775477073812284720L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LOGIN, String.class, login);
        visitor.visit(this, PROPERTY_PASSWORD, String.class, password);
        visitor.visit(this, PROPERTY_FIRST_NAME, String.class, firstName);
        visitor.visit(this, PROPERTY_LAST_NAME, String.class, lastName);
        visitor.visit(this, PROPERTY_ADMINISTRATOR, boolean.class, administrator);
        visitor.visit(this, PROPERTY_LANGUAGE, String.class, language);
        visitor.visit(this, PROPERTY_EMAIL, String.class, email);
        visitor.visit(this, PROPERTY_FAVORITE_LIST, List.class, PersonList.class, favoriteList);
        visitor.visit(this, PROPERTY_POLL_ACCOUNT, List.class, PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public void setLogin(String login) {
        String oldValue = this.login;
        fireOnPreWrite(PROPERTY_LOGIN, oldValue, login);
        this.login = login;
        fireOnPostWrite(PROPERTY_LOGIN, oldValue, login);
    }

    @Override
    public String getLogin() {
        fireOnPreRead(PROPERTY_LOGIN, login);
        String result = this.login;
        fireOnPostRead(PROPERTY_LOGIN, login);
        return result;
    }

    @Override
    public void setPassword(String password) {
        String oldValue = this.password;
        fireOnPreWrite(PROPERTY_PASSWORD, oldValue, password);
        this.password = password;
        fireOnPostWrite(PROPERTY_PASSWORD, oldValue, password);
    }

    @Override
    public String getPassword() {
        fireOnPreRead(PROPERTY_PASSWORD, password);
        String result = this.password;
        fireOnPostRead(PROPERTY_PASSWORD, password);
        return result;
    }

    @Override
    public void setFirstName(String firstName) {
        String oldValue = this.firstName;
        fireOnPreWrite(PROPERTY_FIRST_NAME, oldValue, firstName);
        this.firstName = firstName;
        fireOnPostWrite(PROPERTY_FIRST_NAME, oldValue, firstName);
    }

    @Override
    public String getFirstName() {
        fireOnPreRead(PROPERTY_FIRST_NAME, firstName);
        String result = this.firstName;
        fireOnPostRead(PROPERTY_FIRST_NAME, firstName);
        return result;
    }

    @Override
    public void setLastName(String lastName) {
        String oldValue = this.lastName;
        fireOnPreWrite(PROPERTY_LAST_NAME, oldValue, lastName);
        this.lastName = lastName;
        fireOnPostWrite(PROPERTY_LAST_NAME, oldValue, lastName);
    }

    @Override
    public String getLastName() {
        fireOnPreRead(PROPERTY_LAST_NAME, lastName);
        String result = this.lastName;
        fireOnPostRead(PROPERTY_LAST_NAME, lastName);
        return result;
    }

    @Override
    public void setAdministrator(boolean administrator) {
        boolean oldValue = this.administrator;
        fireOnPreWrite(PROPERTY_ADMINISTRATOR, oldValue, administrator);
        this.administrator = administrator;
        fireOnPostWrite(PROPERTY_ADMINISTRATOR, oldValue, administrator);
    }

    @Override
    public boolean isAdministrator() {
        fireOnPreRead(PROPERTY_ADMINISTRATOR, administrator);
        boolean result = this.administrator;
        fireOnPostRead(PROPERTY_ADMINISTRATOR, administrator);
        return result;
    }

    @Override
    public void setLanguage(String language) {
        String oldValue = this.language;
        fireOnPreWrite(PROPERTY_LANGUAGE, oldValue, language);
        this.language = language;
        fireOnPostWrite(PROPERTY_LANGUAGE, oldValue, language);
    }

    @Override
    public String getLanguage() {
        fireOnPreRead(PROPERTY_LANGUAGE, language);
        String result = this.language;
        fireOnPostRead(PROPERTY_LANGUAGE, language);
        return result;
    }

    @Override
    public void setEmail(String email) {
        String oldValue = this.email;
        fireOnPreWrite(PROPERTY_EMAIL, oldValue, email);
        this.email = email;
        fireOnPostWrite(PROPERTY_EMAIL, oldValue, email);
    }

    @Override
    public String getEmail() {
        fireOnPreRead(PROPERTY_EMAIL, email);
        String result = this.email;
        fireOnPostRead(PROPERTY_EMAIL, email);
        return result;
    }

    @Override
    public void addFavoriteList(PersonList favoriteList) {
        fireOnPreWrite(PROPERTY_FAVORITE_LIST, null, favoriteList);
        if (this.favoriteList == null) {
            this.favoriteList = new ArrayList<PersonList>();
        }

        favoriteList.setOwner(this);

        this.favoriteList.add(favoriteList);
        fireOnPostWrite(PROPERTY_FAVORITE_LIST, this.favoriteList.size(), null, favoriteList);
    }

    @Override
    public void addAllFavoriteList(List<PersonList> favoriteList) {
        if (favoriteList == null) {
            return;
        }
        for (PersonList item : favoriteList) {
            addFavoriteList(item);
        }
    }

    @Override
    public void setFavoriteList(List<PersonList> favoriteList) {
        // Copy elements to keep data for fire with new reference
        List<PersonList> oldValue = this.favoriteList != null ? new ArrayList<PersonList>(this.favoriteList) : null;
        fireOnPreWrite(PROPERTY_FAVORITE_LIST, oldValue, favoriteList);
        this.favoriteList = favoriteList;
        fireOnPostWrite(PROPERTY_FAVORITE_LIST, oldValue, favoriteList);
    }

    @Override
    public void removeFavoriteList(PersonList favoriteList) {
        fireOnPreWrite(PROPERTY_FAVORITE_LIST, favoriteList, null);
        if (this.favoriteList == null || !this.favoriteList.remove(favoriteList)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        favoriteList.setOwner(null);

        fireOnPostWrite(PROPERTY_FAVORITE_LIST, this.favoriteList.size() + 1, favoriteList, null);
    }

    @Override
    public void clearFavoriteList() {
        if (this.favoriteList == null) {
            return;
        }
        for (PersonList item : this.favoriteList) {
            item.setOwner(null);
        }
        List<PersonList> oldValue = new ArrayList<PersonList>(this.favoriteList);
        fireOnPreWrite(PROPERTY_FAVORITE_LIST, oldValue, this.favoriteList);
        this.favoriteList.clear();
        fireOnPostWrite(PROPERTY_FAVORITE_LIST, oldValue, this.favoriteList);
    }

    @Override
    public List<PersonList> getFavoriteList() {
        return favoriteList;
    }

    @Override
    public PersonList getFavoriteListByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(favoriteList, topiaId);
    }

    @Override
    public int sizeFavoriteList() {
        if (favoriteList == null) {
            return 0;
        }
        return favoriteList.size();
    }

    @Override
    public boolean isFavoriteListEmpty() {
        int size = sizeFavoriteList();
        return size == 0;
    }

    @Override
    public void addPollAccount(PollAccount pollAccount) {
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }

        pollAccount.setUserAccount(this);

        this.pollAccount.add(pollAccount);
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, this.pollAccount.size(), null, pollAccount);
    }

    @Override
    public void addAllPollAccount(List<PollAccount> pollAccount) {
        if (pollAccount == null) {
            return;
        }
        for (PollAccount item : pollAccount) {
            addPollAccount(item);
        }
    }

    @Override
    public void setPollAccount(List<PollAccount> pollAccount) {
        // Copy elements to keep data for fire with new reference
        List<PollAccount> oldValue = this.pollAccount != null ? new ArrayList<PollAccount>(this.pollAccount) : null;
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
        this.pollAccount = pollAccount;
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, pollAccount);
    }

    @Override
    public void removePollAccount(PollAccount pollAccount) {
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, pollAccount, null);
        if (this.pollAccount == null || !this.pollAccount.remove(pollAccount)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        pollAccount.setUserAccount(null);

        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, this.pollAccount.size() + 1, pollAccount, null);
    }

    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setUserAccount(null);
        }
        List<PollAccount> oldValue = new ArrayList<PollAccount>(this.pollAccount);
        fireOnPreWrite(PROPERTY_POLL_ACCOUNT, oldValue, this.pollAccount);
        this.pollAccount.clear();
        fireOnPostWrite(PROPERTY_POLL_ACCOUNT, oldValue, this.pollAccount);
    }

    @Override
    public List<PollAccount> getPollAccount() {
        return pollAccount;
    }

    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(pollAccount, topiaId);
    }

    @Override
    public int sizePollAccount() {
        if (pollAccount == null) {
            return 0;
        }
        return pollAccount.size();
    }

    @Override
    public boolean isPollAccountEmpty() {
        int size = sizePollAccount();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //UserAccountAbstract
