package org.chorem.lima.web.action;

/*
 * #%L
 * Lima :: web
 * %%
 * Copyright (C) 2008 - 2014 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Maps;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.beans.DocumentReport;
import org.chorem.lima.business.LimaServiceConfig;
import org.chorem.lima.business.utils.DocumentsEnum;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by davidcosse on 02/10/14.
 */
public class ReportBuilder {

    private static final Log log = LogFactory.getLog(ReportBuilder.class);

    protected JasperReport balanceDocumentReport;
    protected JasperReport generalEntryBookDocumentReport;
    protected JasperReport entryBookDocumentReport;
    protected JasperReport generalLedgerDocumentReport;
    protected Map<DocumentsEnum, JasperReport> reportsByDocumentType;

    public ReportBuilder() {
        try {
            LimaServiceConfig config = LimaServiceConfig.getInstance();

            // compile phase
            balanceDocumentReport = JasperCompileManager.compileReport(config.getBalanceDocumentReportModelPath());
            generalEntryBookDocumentReport = JasperCompileManager.compileReport(config.getGeneralEntryBookDocumentReportModelPath());
            entryBookDocumentReport = JasperCompileManager.compileReport(config.getEntryBookDocumentReportModelPath());
            generalLedgerDocumentReport = JasperCompileManager.compileReport(config.getGeneralLedgerDocumentReportModelPath());


            reportsByDocumentType = Maps.newHashMap();
            reportsByDocumentType.put(DocumentsEnum.BALANCE, balanceDocumentReport);
            reportsByDocumentType.put(DocumentsEnum.GENERAL_ENTRYBOOK, generalEntryBookDocumentReport);
            reportsByDocumentType.put(DocumentsEnum.ENTRYBOOKS, entryBookDocumentReport);
            reportsByDocumentType.put(DocumentsEnum.LEDGER, generalLedgerDocumentReport);
        } catch (JRException e) {
            throw new LimaTechnicalException(e);
        }
    }

    public void generatePDFReport(DocumentsEnum reportType, String path, List<DocumentReport> reports) {

        try {
            JasperReport report = reportsByDocumentType.get(reportType);
            if (report != null) {
                JasperPrint jasperPrint = JasperFillManager.fillReport(report, new HashMap(), new JRBeanCollectionDataSource(reports));
                JasperExportManager.exportReportToPdfFile(jasperPrint, path);
                if (log.isInfoEnabled()) {
                    log.info("Rapport généré:"+path);
                }
            } else {
                throw new LimaTechnicalException("JasperReport not found for " + reportType);
            }

        } catch (JRException e) {
            throw new LimaTechnicalException(e);
        }

    }
}
