/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.server;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.chorem.lima.LimaTechnicalException;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.i18n.I18n;

public class LimaServerConfig {
    protected static final Log log = LogFactory.getLog(LimaServerConfig.class);
    protected ApplicationConfig config;
    protected static LimaServerConfig instance;
    public static final String DEFAULT_CONFIG_FILE_NAME = "lima-server.config";

    private LimaServerConfig(String configFileName) {
        try {
            ApplicationConfig defaultConfig = new ApplicationConfig(DEFAULT_CONFIG_FILE_NAME);
            defaultConfig.loadDefaultOptions((ConfigOptionDef[])ServerConfigOption.values());
            defaultConfig.parse(new String[0]);
            if (StringUtils.isNotBlank((CharSequence)configFileName)) {
                Properties flatOptions = defaultConfig.getFlatOptions(false);
                this.config = new ApplicationConfig(flatOptions, configFileName);
                this.config.parse(new String[0]);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No specific configuration provided, using the default one");
                }
                this.config = defaultConfig;
            }
            instance = this;
        }
        catch (ArgumentsParserException ex) {
            throw new LimaTechnicalException("Can't read configuration", (Throwable)ex);
        }
    }

    private LimaServerConfig(ApplicationConfig config) {
        try {
            ApplicationConfig defaultConfig = new ApplicationConfig(DEFAULT_CONFIG_FILE_NAME);
            defaultConfig.loadDefaultOptions((ConfigOptionDef[])ServerConfigOption.values());
            defaultConfig.parse(new String[0]);
            if (config != null) {
                Properties flatOptions = defaultConfig.getFlatOptions();
                flatOptions.putAll((Map<?, ?>)config.getFlatOptions(true));
                this.config = new ApplicationConfig(flatOptions, DEFAULT_CONFIG_FILE_NAME);
                this.config.parse(new String[0]);
            } else {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No specific configuration provided, using the default one");
                }
                this.config = defaultConfig;
            }
            instance = this;
        }
        catch (ArgumentsParserException ex) {
            throw new LimaTechnicalException("Can't read configuration", (Throwable)ex);
        }
    }

    public static synchronized LimaServerConfig getInstance(String configFileName) {
        if (instance == null) {
            instance = new LimaServerConfig(configFileName);
        }
        return instance;
    }

    public static synchronized LimaServerConfig getInstance(ApplicationConfig config) {
        if (instance == null) {
            instance = new LimaServerConfig(config);
        }
        return instance;
    }

    public static synchronized LimaServerConfig getInstance() {
        return LimaServerConfig.getInstance("");
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public Properties getFlatOptions() {
        return this.config.getFlatOptions();
    }

    public static enum ServerConfigOption implements ConfigOptionDef
    {
        EJB_INITIAL_CONTEXT_FACTORY("java.naming.factory.initial", "", LocalInitialContextFactory.class.getName(), String.class, false, true),
        EJB_REMOTABLE("openejb.embedded.remotable", "", "true", Boolean.class, false, true),
        EJB_PORT("ejbd.port", "", "4202", Integer.class, false, false),
        EJB_BIND("ejbd.bind", "", "0.0.0.0", String.class, false, false);

        private final String key;
        private final String description;
        private String defaultValue;
        private final Class<?> type;
        private boolean transientBoolean;
        private boolean finalBoolean;

        private ServerConfigOption(String key, String description, String defaultValue, Class<?> type, boolean transientBoolean, boolean finalBoolean) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.finalBoolean = finalBoolean;
            this.transientBoolean = transientBoolean;
        }

        public boolean isFinal() {
            return this.finalBoolean;
        }

        public void setFinal(boolean finalBoolean) {
            this.finalBoolean = finalBoolean;
        }

        public boolean isTransient() {
            return this.transientBoolean;
        }

        public void setTransient(boolean transientBoolean) {
            this.transientBoolean = transientBoolean;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDescription() {
            return I18n.t((String)this.description, (Object[])new Object[0]);
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

