/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.server;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaTechnicalException;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.business.api.OptionsService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.report.DocumentsEnum;
import org.chorem.lima.report.service.DocumentService;
import org.chorem.lima.report.service.GeneratedReport;
import org.chorem.lima.server.FormatsEnum;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.hibernate.exception.GenericJDBCException;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class HttpServerService {
    protected static final Log log = LogFactory.getLog(HttpServerService.class);
    protected static final String DATE_FORMAT = "yyyy-MM-dd";
    protected DocumentService documentService;
    protected Server server;
    protected String limaHttpHost;
    protected int limaHttpPort;

    public HttpServerService() {
        this.init();
    }

    public void start() {
        if (this.server == null) {
            try {
                this.server = new Server(this.limaHttpPort);
                ServletContextHandler context = new ServletContextHandler(1);
                context.setContextPath("/");
                context.addServlet(new ServletHolder((Servlet)new MainServlet()), "/");
                this.server.setHandler((Handler)context);
                this.server.start();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Web server running on port: " + this.limaHttpPort));
                }
            }
            catch (Exception eee) {
                log.error((Object)"error while booting http server", (Throwable)eee);
            }
        }
    }

    protected void init() {
        OptionsService optionsService = (OptionsService)LimaServiceFactory.getService(OptionsService.class);
        this.limaHttpHost = optionsService.getLimaHttpHost();
        this.limaHttpPort = optionsService.getLimaHttpPort();
        this.documentService = new DocumentService();
    }

    public class MainServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            this.doGet(req, resp);
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            try {
                String account;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"doGet");
                }
                String imageParam = req.getParameter("img");
                String model = req.getParameter("model");
                String beginDate = req.getParameter("beginDate");
                String endDate = req.getParameter("endDate");
                String string = account = StringUtils.isBlank((CharSequence)req.getParameter("account")) ? null : URLDecoder.decode(req.getParameter("account"), "UTF-8");
                if (imageParam != null) {
                    this.doImage(resp, imageParam);
                } else if (model != null && beginDate != null && endDate != null) {
                    this.doCreateReport(resp, model, beginDate, endDate, account);
                } else {
                    this.doHomeHtml(req, resp);
                }
            }
            catch (GenericJDBCException eee) {
                log.error((Object)"Can't read db", (Throwable)eee);
            }
        }

        protected void doImage(HttpServletResponse resp, String imageParam) throws IOException {
            URL image = Resource.getURLOrNull((String)("images/" + imageParam));
            if (image != null) {
                resp.setContentType(FormatsEnum.PNG.getMimeType());
                InputStream in = image.openStream();
                ServletOutputStream out = resp.getOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }

        protected void doCreateReport(HttpServletResponse resp, String model, String beginDate, String endDate, String account) throws IOException {
            SimpleDateFormat sdf = new SimpleDateFormat(HttpServerService.DATE_FORMAT);
            try {
                Date beginDateFormat = sdf.parse(beginDate);
                Date endDateFormat = sdf.parse(endDate);
                GeneratedReport generatedReport = HttpServerService.this.documentService.createReport(beginDateFormat, endDateFormat, model, account);
                if (Strings.isNullOrEmpty((String)generatedReport.getHtmlContent())) {
                    InputStream in = generatedReport.getPdfStream();
                    resp.setContentType(FormatsEnum.PDF.getMimeType());
                    ServletOutputStream out = resp.getOutputStream();
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                } else {
                    String report = generatedReport.getHtmlContent();
                    resp.setContentType(FormatsEnum.HTML.getMimeType());
                    ServletOutputStream out = resp.getOutputStream();
                    IOUtils.write((String)report, (OutputStream)out, (Charset)Charsets.UTF_8);
                }
            }
            catch (ParseException pe) {
                throw new LimaTechnicalException("Cannot parse dates", (Throwable)pe);
            }
        }

        protected void doHomeHtml(HttpServletRequest req, HttpServletResponse resp) throws IOException {
            SimpleDateFormat sdf = new SimpleDateFormat(HttpServerService.DATE_FORMAT);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Home html");
            }
            resp.setContentType(FormatsEnum.HTML.getMimeType());
            StringBuilder pageContent = new StringBuilder();
            log.info((Object)"Page load");
            String urlFormat = "http://%s:%d";
            String serverAddress = HttpServerService.this.limaHttpHost.equals("") ? String.format(urlFormat, req.getServerName(), req.getServerPort()) : String.format(urlFormat, HttpServerService.this.limaHttpHost, HttpServerService.this.limaHttpPort);
            Calendar calendar = Calendar.getInstance();
            Date endDatePicker = calendar.getTime();
            Date beginDatePicker = calendar.getTime();
            beginDatePicker = DateUtils.truncate((Date)beginDatePicker, (int)1);
            pageContent.append("<!DOCTYPE html>\n<html lang=\"fr\">\n<head>\n<script type=\"text/javascript\">        function showAccountInput(){          var request = document.getElementById('model');          var requestValue = request == null ? '': request.value;          var isDocumentAccount = requestValue === 'lima_account';           if (document.getElementById('accountField') != null) {            if (isDocumentAccount) {              document.getElementById('accountField').style.display = 'block';            } else {              document.getElementById('accountField').style.display = 'none';            }          }        }      showAccountInput();      </script><title>LIMA Documents Report</title>\n<style type=\"text/css\">body { font: 14px sans-serif; }h1 { font: 20px sans-serif; text-align: center; }table.padding td {padding-right:20px;}.tdright {text-align: right;}</style></head>\n<body>\n<table class=\"padding\">\n<tr><td><img src=\"?img=puzzle_icon_mini.png\"/></td>\n<td><h1>LIMA Documents Report</h1></td></tr>\n<tr><td class=\"tdright\"><img src=\"?img=identity.png\"/></td>\n<td rowspan=3><form method=GET action=").append(serverAddress).append(">\n").append(I18n.t((String)"lima-business.document.date.begin", (Object[])new Object[0])).append("<input value=\"").append(sdf.format(beginDatePicker)).append("\" type=\"date\" name=\"beginDate\">\n").append(I18n.t((String)"lima-business.document.date.end", (Object[])new Object[0])).append("<input value=\"").append(sdf.format(endDatePicker)).append("\" type=\"date\" name=\"endDate\">\n<br/><br/>");
            pageContent.append("Documents : <select id=\"model\" name=\"model\" onchange='showAccountInput()'>");
            for (DocumentsEnum documentsEnum : DocumentsEnum.values()) {
                pageContent.append("<option value=\"").append(documentsEnum.getFileName()).append("\">").append(documentsEnum.getDescription()).append("</option>\n");
            }
            List accounts = HttpServerService.this.documentService.getAllAccounts();
            StringBuilder optionAccounts = new StringBuilder();
            for (Account account1 : accounts) {
                optionAccounts.append("<option value=\"" + account1.getTopiaId() + "\">");
                optionAccounts.append(account1.getAccountNumber() + " - " + account1.getLabel());
                optionAccounts.append("</option>\n");
            }
            pageContent.append("</select><div id='accountField'>Compte : <select id=\"account\" name=\"account\">" + optionAccounts.toString() + "</select></div>" + "<input type=\"submit\">\n" + "</form></td>" + "<tr><td class=\"tdright\"><img src=\"?img=entries.png\"/></td></tr>\n" + "<tr><td class=\"tdright\"><img src=\"?img=accounts.png\"/></td></tr>\n" + "<tr><td class=\"tdright\"><img src=\"?img=entrybooks.png\"/></td>\n" + "<tr><td class=\"tdright\"><img src=\"?img=fiscalperiods.png\"/></td></tr>\n" + "</table>\n" + "<script type=\"text/javascript\">" + "  showAccountInput();" + "</script>" + "</body>\n" + "</html>");
            resp.getWriter().write(pageContent.toString());
        }
    }
}

