/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc.impl;

import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;

public class ImplAverageDownSampleN {
    public static void down(GrayU8 input, int sampleWidth, GrayI8 output) {
        int xx;
        int indexIn;
        int yy;
        int total;
        int endBoxY;
        int indexOut;
        int outY;
        int y;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        for (y = 0; y < maxY; y += sampleWidth) {
            outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total2 = 0;
                for (int yy2 = y; yy2 < endBoxY; ++yy2) {
                    int indexIn2 = input.startIndex + yy2 * input.stride + x;
                    for (int xx2 = x; xx2 < endBoxX; ++xx2) {
                        total2 += input.data[indexIn2++] & 0xFF;
                    }
                }
                output.data[indexOut++] = (byte)((total2 + N_half) / N);
            }
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            for (y = 0; y < maxY; y += sampleWidth) {
                outY = y / sampleWidth;
                indexOut = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                total = 0;
                for (yy = y; yy < endBoxY; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + maxX;
                    for (xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut] = (byte)((total + N_half) / N);
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                total = 0;
                for (yy = maxY; yy < input.height; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + x;
                    for (xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFF;
                    }
                }
                output.data[indexOut] = (byte)((total + N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut2 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total3 = 0;
            for (int yy3 = maxY; yy3 < input.height; ++yy3) {
                int indexIn3 = input.startIndex + yy3 * input.stride + maxX;
                for (int xx3 = maxX; xx3 < input.width; ++xx3) {
                    total3 += input.data[indexIn3++] & 0xFF;
                }
            }
            output.data[indexOut2] = (byte)((total3 + N_half) / N);
        }
    }

    public static void down(GrayS8 input, int sampleWidth, GrayI8 output) {
        int xx;
        int indexIn;
        int yy;
        int total;
        int endBoxY;
        int indexOut;
        int outY;
        int y;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        for (y = 0; y < maxY; y += sampleWidth) {
            outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total2 = 0;
                for (int yy2 = y; yy2 < endBoxY; ++yy2) {
                    int indexIn2 = input.startIndex + yy2 * input.stride + x;
                    for (int xx2 = x; xx2 < endBoxX; ++xx2) {
                        total2 += input.data[indexIn2++];
                    }
                }
                output.data[indexOut++] = total2 >= 0 ? (byte)((total2 + N_half) / N) : (byte)((total2 - N_half) / N);
            }
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            for (y = 0; y < maxY; y += sampleWidth) {
                outY = y / sampleWidth;
                indexOut = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                total = 0;
                for (yy = y; yy < endBoxY; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + maxX;
                    for (xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                total = 0;
                for (yy = maxY; yy < input.height; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + x;
                    for (xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (byte)((total + N_half) / N) : (byte)((total - N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut2 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total3 = 0;
            for (int yy3 = maxY; yy3 < input.height; ++yy3) {
                int indexIn3 = input.startIndex + yy3 * input.stride + maxX;
                for (int xx3 = maxX; xx3 < input.width; ++xx3) {
                    total3 += input.data[indexIn3++];
                }
            }
            output.data[indexOut2] = total3 >= 0 ? (byte)((total3 + N_half) / N) : (byte)((total3 - N_half) / N);
        }
    }

    public static void down(GrayU16 input, int sampleWidth, GrayI16 output) {
        int xx;
        int indexIn;
        int yy;
        int total;
        int endBoxY;
        int indexOut;
        int outY;
        int y;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        for (y = 0; y < maxY; y += sampleWidth) {
            outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total2 = 0;
                for (int yy2 = y; yy2 < endBoxY; ++yy2) {
                    int indexIn2 = input.startIndex + yy2 * input.stride + x;
                    for (int xx2 = x; xx2 < endBoxX; ++xx2) {
                        total2 += input.data[indexIn2++] & 0xFFFF;
                    }
                }
                output.data[indexOut++] = (short)((total2 + N_half) / N);
            }
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            for (y = 0; y < maxY; y += sampleWidth) {
                outY = y / sampleWidth;
                indexOut = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                total = 0;
                for (yy = y; yy < endBoxY; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + maxX;
                    for (xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut] = (short)((total + N_half) / N);
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                total = 0;
                for (yy = maxY; yy < input.height; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + x;
                    for (xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++] & 0xFFFF;
                    }
                }
                output.data[indexOut] = (short)((total + N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut2 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total3 = 0;
            for (int yy3 = maxY; yy3 < input.height; ++yy3) {
                int indexIn3 = input.startIndex + yy3 * input.stride + maxX;
                for (int xx3 = maxX; xx3 < input.width; ++xx3) {
                    total3 += input.data[indexIn3++] & 0xFFFF;
                }
            }
            output.data[indexOut2] = (short)((total3 + N_half) / N);
        }
    }

    public static void down(GrayS16 input, int sampleWidth, GrayI16 output) {
        int xx;
        int indexIn;
        int yy;
        int total;
        int endBoxY;
        int indexOut;
        int outY;
        int y;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        for (y = 0; y < maxY; y += sampleWidth) {
            outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total2 = 0;
                for (int yy2 = y; yy2 < endBoxY; ++yy2) {
                    int indexIn2 = input.startIndex + yy2 * input.stride + x;
                    for (int xx2 = x; xx2 < endBoxX; ++xx2) {
                        total2 += input.data[indexIn2++];
                    }
                }
                output.data[indexOut++] = total2 >= 0 ? (short)((total2 + N_half) / N) : (short)((total2 - N_half) / N);
            }
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            for (y = 0; y < maxY; y += sampleWidth) {
                outY = y / sampleWidth;
                indexOut = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                total = 0;
                for (yy = y; yy < endBoxY; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + maxX;
                    for (xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                total = 0;
                for (yy = maxY; yy < input.height; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + x;
                    for (xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (short)((total + N_half) / N) : (short)((total - N_half) / N);
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut2 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total3 = 0;
            for (int yy3 = maxY; yy3 < input.height; ++yy3) {
                int indexIn3 = input.startIndex + yy3 * input.stride + maxX;
                for (int xx3 = maxX; xx3 < input.width; ++xx3) {
                    total3 += input.data[indexIn3++];
                }
            }
            output.data[indexOut2] = total3 >= 0 ? (short)((total3 + N_half) / N) : (short)((total3 - N_half) / N);
        }
    }

    public static void down(GrayS32 input, int sampleWidth, GrayS32 output) {
        int xx;
        int indexIn;
        int yy;
        int total;
        int endBoxY;
        int indexOut;
        int outY;
        int y;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        int N = sampleWidth * sampleWidth;
        int N_half = N / 2;
        for (y = 0; y < maxY; y += sampleWidth) {
            outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                int total2 = 0;
                for (int yy2 = y; yy2 < endBoxY; ++yy2) {
                    int indexIn2 = input.startIndex + yy2 * input.stride + x;
                    for (int xx2 = x; xx2 < endBoxX; ++xx2) {
                        total2 += input.data[indexIn2++];
                    }
                }
                output.data[indexOut++] = total2 >= 0 ? (total2 + N_half) / N : (total2 - N_half) / N;
            }
        }
        if (maxX != input.width) {
            N = sampleWidth * (input.width - maxX);
            N_half = N / 2;
            for (y = 0; y < maxY; y += sampleWidth) {
                outY = y / sampleWidth;
                indexOut = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                total = 0;
                for (yy = y; yy < endBoxY; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + maxX;
                    for (xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            N_half = N / 2;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                total = 0;
                for (yy = maxY; yy < input.height; ++yy) {
                    indexIn = input.startIndex + yy * input.stride + x;
                    for (xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total >= 0 ? (total + N_half) / N : (total - N_half) / N;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            N_half = N / 2;
            int indexOut2 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            int total3 = 0;
            for (int yy3 = maxY; yy3 < input.height; ++yy3) {
                int indexIn3 = input.startIndex + yy3 * input.stride + maxX;
                for (int xx3 = maxX; xx3 < input.width; ++xx3) {
                    total3 += input.data[indexIn3++];
                }
            }
            output.data[indexOut2] = total3 >= 0 ? (total3 + N_half) / N : (total3 - N_half) / N;
        }
    }

    public static void down(GrayF32 input, int sampleWidth, GrayF32 output) {
        int xx;
        int yy;
        int endBoxY;
        int indexOut;
        int outY;
        int y;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        float N = sampleWidth * sampleWidth;
        for (y = 0; y < maxY; y += sampleWidth) {
            outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                float total = 0.0f;
                for (int yy2 = y; yy2 < endBoxY; ++yy2) {
                    int indexIn = input.startIndex + yy2 * input.stride + x;
                    for (int xx2 = x; xx2 < endBoxX; ++xx2) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total / N;
            }
        }
        if (maxX != input.width) {
            int N2 = sampleWidth * (input.width - maxX);
            for (y = 0; y < maxY; y += sampleWidth) {
                outY = y / sampleWidth;
                indexOut = output.startIndex + outY * output.stride + output.width - 1;
                endBoxY = y + sampleWidth;
                float total = 0.0f;
                for (yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / (float)N2;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                float total = 0.0f;
                for (yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / N;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            int indexOut2 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            float total = 0.0f;
            for (int yy3 = maxY; yy3 < input.height; ++yy3) {
                int indexIn = input.startIndex + yy3 * input.stride + maxX;
                for (int xx3 = maxX; xx3 < input.width; ++xx3) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut2] = total / N;
        }
    }

    public static void down(GrayF64 input, int sampleWidth, GrayF64 output) {
        int indexOut;
        int maxY = input.height - input.height % sampleWidth;
        int maxX = input.width - input.width % sampleWidth;
        double N = sampleWidth * sampleWidth;
        for (int y = 0; y < maxY; y += sampleWidth) {
            int outY = y / sampleWidth;
            indexOut = output.startIndex + outY * output.stride;
            int endBoxY = y + sampleWidth;
            for (int x = 0; x < maxX; x += sampleWidth) {
                int endBoxX = x + sampleWidth;
                double total = 0.0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut++] = total / N;
            }
        }
        if (maxX != input.width) {
            int N2 = sampleWidth * (input.width - maxX);
            for (int y = 0; y < maxY; y += sampleWidth) {
                int outY = y / sampleWidth;
                int indexOut2 = output.startIndex + outY * output.stride + output.width - 1;
                int endBoxY = y + sampleWidth;
                double total = 0.0;
                for (int yy = y; yy < endBoxY; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + maxX;
                    for (int xx = maxX; xx < input.width; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut2] = total / (double)N2;
            }
        }
        if (maxY != input.height) {
            N = (input.height - maxY) * sampleWidth;
            int indexOut0 = output.startIndex + (output.height - 1) * output.stride;
            for (int x = 0; x < maxX; x += sampleWidth) {
                indexOut = indexOut0 + x / sampleWidth;
                int endBoxX = x + sampleWidth;
                double total = 0.0;
                for (int yy = maxY; yy < input.height; ++yy) {
                    int indexIn = input.startIndex + yy * input.stride + x;
                    for (int xx = x; xx < endBoxX; ++xx) {
                        total += input.data[indexIn++];
                    }
                }
                output.data[indexOut] = total / N;
            }
        }
        if (maxX != input.width && maxY != input.height) {
            N = (input.height - maxY) * (input.width - maxX);
            int indexOut3 = output.startIndex + (output.height - 1) * output.stride + output.width - 1;
            double total = 0.0;
            for (int yy = maxY; yy < input.height; ++yy) {
                int indexIn = input.startIndex + yy * input.stride + maxX;
                for (int xx = maxX; xx < input.width; ++xx) {
                    total += input.data[indexIn++];
                }
            }
            output.data[indexOut3] = total / N;
        }
    }
}

