/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology.utils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.biojava.nbio.ontology.utils.Annotation;

public abstract class AbstractAnnotation
implements Annotation,
Serializable {
    private static final long serialVersionUID = 2753449055959952873L;

    protected abstract Map getProperties();

    protected abstract boolean propertiesAllocated();

    @Override
    public Object getProperty(Object key) {
        Map prop;
        if (this.propertiesAllocated() && (prop = this.getProperties()).containsKey(key)) {
            return prop.get(key);
        }
        throw new NoSuchElementException("Property " + key + " unknown");
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.getProperties().put(key, value);
    }

    @Override
    public void removeProperty(Object key) {
        if (!this.getProperties().containsKey(key)) {
            throw new NoSuchElementException("Can't remove key " + key.toString());
        }
        this.getProperties().remove(key);
    }

    @Override
    public boolean containsProperty(Object key) {
        if (this.propertiesAllocated()) {
            return this.getProperties().containsKey(key);
        }
        return false;
    }

    @Override
    public Set keys() {
        if (this.propertiesAllocated()) {
            return this.getProperties().keySet();
        }
        return Collections.EMPTY_SET;
    }

    public String toString() {
        Object key;
        StringBuffer sb = new StringBuffer("{");
        Map prop = this.getProperties();
        Iterator i = prop.keySet().iterator();
        if (i.hasNext()) {
            key = i.next();
            sb.append(key).append("=").append(prop.get(key));
        }
        while (i.hasNext()) {
            key = i.next();
            sb.append(",").append(key).append("=").append(prop.get(key));
        }
        sb.append("}");
        return sb.substring(0);
    }

    @Override
    public Map asMap() {
        return Collections.unmodifiableMap(this.getProperties());
    }

    protected AbstractAnnotation() {
    }

    protected AbstractAnnotation(Annotation ann) {
        if (ann == null) {
            throw new NullPointerException("Null annotation not allowed. Use Annotation.EMPTY_ANNOTATION instead.");
        }
        if (ann == Annotation.EMPTY_ANNOTATION) {
            return;
        }
        Map properties = this.getProperties();
        for (Object key : ann.keys()) {
            try {
                properties.put(key, ann.getProperty(key));
            }
            catch (IllegalArgumentException iae) {
                throw new RuntimeException("Property was there and then disappeared: " + key, iae);
            }
        }
    }

    public AbstractAnnotation(Map annMap) {
        if (annMap == null) {
            throw new IllegalArgumentException("Null annotation Map not allowed. Use an empy map instead.");
        }
        if (annMap.isEmpty()) {
            return;
        }
        Map properties = this.getProperties();
        for (Object key : annMap.keySet()) {
            properties.put(key, annMap.get(key));
        }
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Annotation)) {
            return false;
        }
        return ((Annotation)o).asMap().equals(this.asMap());
    }
}

